/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.examples;

import com.atlassian.servicedesk.api.rest.dto.domain.request.CustomerRequestDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.request.CustomerRequestDTOFactory;
import com.atlassian.servicedesk.api.rest.dto.domain.request.CustomerRequestFieldValueDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.request.CustomerRequestLinkDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.request.RequestCreateDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.request.status.CustomerRequestStatusDTO;
import com.atlassian.servicedesk.api.rest.dto.paging.PagedDTO;
import com.atlassian.servicedesk.api.rest.examples.ExampleHelper;
import com.atlassian.servicedesk.api.rest.examples.UserExamples;
import com.atlassian.servicedesk.api.rest.util.uri.UriKit;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;

public class CustomerRequestExamples {
    private static final String REQUEST_SUMMARY = "Request JSD help via REST";
    private static final String NEED_A_NEW_MOUSE_FOR_MY_MAC = "I need a new mouse for my Mac";
    private static final CustomerRequestExample A = new CustomerRequestExample("107001", "HELPDESK-1", "10", "10000", "25", "10096");
    private static final CustomerRequestExample B = new CustomerRequestExample("107002", "HELPDESK-2", "10", "10000", "25", "10096");
    private static final CustomerRequestExample C = new CustomerRequestExample("109006", "SIMPLEDESK-6", "12", "10002", "33", "10049");
    public static final RequestCreateDTO CREATE_PARAMS = RequestCreateDTO.builder().setServiceDeskId(A.getServiceDeskId()).setRequestTypeId(A.getRequestTypeId()).setRequestFieldValues((Map<String, Object>)ImmutableMap.builder().put((Object)"summary", (Object)"Request JSD help via REST").put((Object)"description", (Object)"I need a new mouse for my Mac").build()).addRequestParticipant("john").build();
    public static final CustomerRequestDTO CREATED_RESPONSE = CustomerRequestDTO.builder().setIssueId(A.getIssueId()).setIssueKey(A.getIssueKey()).setServiceDeskId(A.getServiceDeskId()).setRequestTypeId(A.getRequestTypeId()).setIssueTypeId(A.getIssueTypeId()).setProjectId(A.getProjectId()).setCurrentStatus(CustomerRequestStatusDTO.builder().setStatus("Waiting for Support").setStatusDate(ExampleHelper.dateDTO(2015, 10, 8, 14, 1, "Today")).build()).setCreatedDate(ExampleHelper.dateDTO(2015, 10, 8, 14, 42, "Monday")).setReporter(UserExamples.FRED).setRequestFieldValues((List<CustomerRequestFieldValueDTO>)ImmutableList.of((Object)CustomerRequestFieldValueDTO.builder().setFieldId("summary").setValue("Request JSD help via REST").setLabel("What do you need?").build(), (Object)CustomerRequestFieldValueDTO.builder().setFieldId("description").setLabel("Why do you need this?").setValue("I need a new mouse for my Mac").build())).set_links(CustomerRequestExamples.buildLinks(A.getServiceDeskId(), A.getIssueId(), A.getIssueKey())).setExpands(CustomerRequestDTOFactory.REQUEST_EXPANSIONS).build();
    public static final PagedDTO EXAMPLE_PAGE = ExampleHelper.standardPagedExample(3, "request", new Object[0]).addValue(CREATED_RESPONSE).addValue(CustomerRequestDTO.builder().setIssueId(B.getIssueId()).setIssueKey(B.getIssueKey()).setServiceDeskId(B.getServiceDeskId()).setRequestTypeId(B.getRequestTypeId()).setIssueTypeId(B.getIssueTypeId()).setProjectId(B.getProjectId()).setCurrentStatus(CustomerRequestStatusDTO.builder().setStatus("Waiting for Support").setStatusDate(ExampleHelper.dateDTO(2015, 10, 8, 14, 1, "Today")).build()).setCreatedDate(ExampleHelper.dateDTO(2015, 10, 8, 14, 30, "Monday")).setReporter(UserExamples.FRED).setRequestFieldValues((List<CustomerRequestFieldValueDTO>)ImmutableList.of((Object)CustomerRequestFieldValueDTO.builder().setFieldId("summary").setValue("Request a new account").setLabel("What do you need?").build(), (Object)CustomerRequestFieldValueDTO.builder().setFieldId("description").setLabel("Why do you need this?").setValue("Create an account on JIRA").build())).set_links(CustomerRequestExamples.buildLinks(B.getServiceDeskId(), B.getIssueId(), B.getIssueKey())).setExpands(CustomerRequestDTOFactory.REQUEST_EXPANSIONS).build()).addValue(CustomerRequestDTO.builder().setIssueId(C.getIssueId()).setIssueKey(C.getIssueKey()).setServiceDeskId(C.getServiceDeskId()).setRequestTypeId(C.getRequestTypeId()).setIssueTypeId(C.getIssueTypeId()).setProjectId(C.getProjectId()).setCurrentStatus(CustomerRequestStatusDTO.builder().setStatus("Waiting for Support").setStatusDate(ExampleHelper.dateDTO(2015, 10, 8, 14, 0, "Today")).build()).setCreatedDate(ExampleHelper.dateDTO(2015, 10, 5, 14, 30, "Monday")).setReporter(UserExamples.FRED).setRequestFieldValues((List<CustomerRequestFieldValueDTO>)ImmutableList.of((Object)CustomerRequestFieldValueDTO.builder().setFieldId("summary").setValue("Printer on level 3 did not work").setLabel("Summarize the problem").build(), (Object)CustomerRequestFieldValueDTO.builder().setFieldId("description").setValue("Ink cartridge is empty").build())).set_links(CustomerRequestExamples.buildLinks(CustomerRequestExample.access$000(C), C.getIssueId(), C.getIssueKey())).setExpands(CustomerRequestDTOFactory.REQUEST_EXPANSIONS).build()).build();

    private static CustomerRequestLinkDTO buildLinks(String serviceDeskId, String issueId, String issueKey) {
        return CustomerRequestLinkDTO.builder().setSelf(ExampleHelper.jsdRestApiExampleUri("request/{requestId}").buildSelfLink(issueId).getSelf()).setWeb(UriKit.toURI("http://host:port/context/servicedesk/customer/portal/" + serviceDeskId + "/" + issueKey)).setJiraRest(UriKit.toURI("http://host:port/context/rest/api/2/issue/" + issueId)).build();
    }

    private static class CustomerRequestExample {
        private final String issueId;
        private final String issueKey;
        private final String serviceDeskId;
        private final String projectId;
        private final String requestTypeId;
        private final String issueTypeId;

        public String getIssueId() {
            return this.issueId;
        }

        public String getIssueKey() {
            return this.issueKey;
        }

        public String getServiceDeskId() {
            return this.serviceDeskId;
        }

        public String getProjectId() {
            return this.projectId;
        }

        public String getRequestTypeId() {
            return this.requestTypeId;
        }

        public String getIssueTypeId() {
            return this.issueTypeId;
        }

        public CustomerRequestExample(String issueId, String issueKey, String serviceDeskId, String projectId, String requestTypeId, String issueTypeId) {
            this.issueId = issueId;
            this.issueKey = issueKey;
            this.serviceDeskId = serviceDeskId;
            this.projectId = projectId;
            this.requestTypeId = requestTypeId;
            this.issueTypeId = issueTypeId;
        }

        static /* synthetic */ String access$000(CustomerRequestExample x0) {
            return x0.serviceDeskId;
        }
    }
}

