/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.dto.paging;

import com.atlassian.servicedesk.api.rest.dto.paging.PagedLinkDTO;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonAutoDetect
public class PagedDTO<T> {
    @JsonProperty(value="_expands")
    private final List<String> expands;
    private final Integer size;
    private final Integer start;
    private final Integer limit;
    private final Boolean isLastPage;
    private final PagedLinkDTO _links;
    private final List<T> values;

    @JsonCreator
    public PagedDTO(@JsonProperty(value="_expands") List<String> expands, @JsonProperty(value="size") Integer size, @JsonProperty(value="start") Integer start, @JsonProperty(value="limit") Integer limit, @JsonProperty(value="isLastPage") Boolean isLastPage, @JsonProperty(value="_links") PagedLinkDTO _links, @JsonProperty(value="values") List<T> values) {
        this.expands = expands != null ? ImmutableList.copyOf(expands) : null;
        this.size = size;
        this.start = start;
        this.limit = limit;
        this.isLastPage = isLastPage;
        this._links = _links;
        this.values = values != null ? ImmutableList.copyOf(values) : null;
    }

    public List<String> getExpands() {
        return this.expands;
    }

    public Integer getSize() {
        return this.size;
    }

    public Integer getStart() {
        return this.start;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Boolean getIsLastPage() {
        return this.isLastPage;
    }

    public PagedLinkDTO get_links() {
        return this._links;
    }

    public List<T> getValues() {
        return this.values;
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static <T> Builder<T> builder(PagedDTO<T> data) {
        return new Builder(data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PagedDTO that = (PagedDTO)o;
        return Objects.equals(this.getExpands(), that.getExpands()) && Objects.equals(this.getSize(), that.getSize()) && Objects.equals(this.getStart(), that.getStart()) && Objects.equals(this.getLimit(), that.getLimit()) && Objects.equals(this.getIsLastPage(), that.getIsLastPage()) && Objects.equals(this.get_links(), that.get_links()) && Objects.equals(this.getValues(), that.getValues());
    }

    public int hashCode() {
        return Objects.hash(this.getExpands(), this.getSize(), this.getStart(), this.getLimit(), this.getIsLastPage(), this.get_links(), this.getValues());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("expands", this.getExpands()).add("size", (Object)this.getSize()).add("start", (Object)this.getStart()).add("limit", (Object)this.getLimit()).add("isLastPage", (Object)this.getIsLastPage()).add("_links", (Object)this.get_links()).add("values", this.getValues()).toString();
    }

    public static final class Builder<T> {
        private List<String> expands = Lists.newArrayList();
        private Integer size;
        private Integer start;
        private Integer limit;
        private Boolean isLastPage;
        private PagedLinkDTO _links;
        private List<T> values = Lists.newArrayList();

        private Builder() {
        }

        private Builder(PagedDTO<T> initialData) {
            this.expands = Lists.newArrayList(initialData.getExpands());
            this.size = initialData.getSize();
            this.start = initialData.getStart();
            this.limit = initialData.getLimit();
            this.isLastPage = initialData.getIsLastPage();
            this._links = initialData.get_links();
            this.values = Lists.newArrayList(initialData.getValues());
        }

        public Builder<T> setExpands(List<String> expands) {
            this.expands = expands;
            return this;
        }

        public Builder<T> addExpand(String expand) {
            this.expands.add(expand);
            return this;
        }

        public Builder<T> addExpands(Iterable<String> expands) {
            for (String expand : expands) {
                this.addExpand(expand);
            }
            return this;
        }

        public Builder<T> setSize(Integer size) {
            this.size = size;
            return this;
        }

        public Builder<T> setStart(Integer start) {
            this.start = start;
            return this;
        }

        public Builder<T> setLimit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder<T> setIsLastPage(Boolean isLastPage) {
            this.isLastPage = isLastPage;
            return this;
        }

        public Builder<T> set_links(PagedLinkDTO _links) {
            this._links = _links;
            return this;
        }

        public Builder<T> setValues(List<T> values) {
            this.values = values;
            return this;
        }

        public Builder<T> addValue(T value) {
            this.values.add(value);
            return this;
        }

        public Builder<T> addValues(Iterable<T> values) {
            for (T value : values) {
                this.addValue(value);
            }
            return this;
        }

        public PagedDTO<T> build() {
            return new PagedDTO<T>(this.expands, this.size, this.start, this.limit, this.isLastPage, this._links, this.values);
        }
    }
}

