/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.dto.domain.user;

import com.atlassian.annotations.tenancy.TenancyScope;
import com.atlassian.annotations.tenancy.TenantAware;
import com.atlassian.servicedesk.api.rest.dto.links.SelfLinkDTO;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonAutoDetect
public class UserLinkDTO
extends SelfLinkDTO {
    private final URI jiraRest;
    @TenantAware(value=TenancyScope.TENANTED)
    private final Map<String, String> avatarUrls;

    @JsonCreator
    public UserLinkDTO(@JsonProperty(value="jiraRest") URI jiraRest, @JsonProperty(value="avatarUrls") Map<String, String> avatarUrls, @JsonProperty(value="self") URI self) {
        super(self);
        this.jiraRest = jiraRest;
        this.avatarUrls = avatarUrls != null ? ImmutableMap.copyOf(avatarUrls) : null;
    }

    public URI getJiraRest() {
        return this.jiraRest;
    }

    public Map<String, String> getAvatarUrls() {
        return this.avatarUrls;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(UserLinkDTO data) {
        return new Builder(data);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserLinkDTO that = (UserLinkDTO)o;
        return Objects.equals(this.getJiraRest(), that.getJiraRest()) && Objects.equals(this.getAvatarUrls(), that.getAvatarUrls()) && Objects.equals(this.getSelf(), that.getSelf());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getJiraRest(), this.getAvatarUrls(), this.getSelf());
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("jiraRest", (Object)this.getJiraRest()).add("avatarUrls", this.getAvatarUrls()).add("self", (Object)this.getSelf()).toString();
    }

    public static final class Builder {
        private URI jiraRest;
        @TenantAware(value=TenancyScope.TENANTED)
        private Map<String, String> avatarUrls = Maps.newHashMap();
        private URI self;

        private Builder() {
        }

        private Builder(UserLinkDTO initialData) {
            this.jiraRest = initialData.getJiraRest();
            this.avatarUrls = Maps.newHashMap(initialData.getAvatarUrls());
            this.self = initialData.getSelf();
        }

        public Builder setJiraRest(URI jiraRest) {
            this.jiraRest = jiraRest;
            return this;
        }

        public Builder setAvatarUrls(Map<String, String> avatarUrls) {
            this.avatarUrls = avatarUrls;
            return this;
        }

        public Builder addAvatarUrls(Map<String, String> avatarUrls) {
            this.avatarUrls.putAll(avatarUrls);
            return this;
        }

        public Builder setSelf(URI self) {
            this.self = self;
            return this;
        }

        public UserLinkDTO build() {
            return new UserLinkDTO(this.jiraRest, this.avatarUrls, this.self);
        }
    }
}

