/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.dto.domain.user;

import com.atlassian.jira.issue.fields.rest.json.UserBeanFactory;
import com.atlassian.jira.issue.fields.rest.json.beans.UserJsonBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.api.rest.dto.DTOFactory;
import com.atlassian.servicedesk.api.rest.dto.domain.user.UserDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.user.UserLinkDTO;
import com.atlassian.servicedesk.api.rest.util.uri.UriKit;
import java.net.URI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserDTOFactory
implements DTOFactory<ApplicationUser, UserDTO> {
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final UserBeanFactory userBeanFactory;

    @Autowired
    public UserDTOFactory(JiraAuthenticationContext jiraAuthenticationContext, UserBeanFactory userBeanFactory) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.userBeanFactory = userBeanFactory;
    }

    @Override
    public UserDTO toDTO(ApplicationUser user) {
        if (user == null) {
            return null;
        }
        UserJsonBean jiraJsonBean = this.userBeanFactory.createBean(user, this.jiraAuthenticationContext.getLoggedInUser());
        URI jiraRestUrl = UriKit.toURI(jiraJsonBean.getSelf());
        UserLinkDTO userLinks = UserLinkDTO.builder().setAvatarUrls(jiraJsonBean.getAvatarUrls()).setJiraRest(jiraRestUrl).setSelf(jiraRestUrl).build();
        return UserDTO.builder().setKey(jiraJsonBean.getKey()).setName(jiraJsonBean.getName()).setDisplayName(jiraJsonBean.getDisplayName()).setEmailAddress(jiraJsonBean.getEmailAddress()).setTimeZone(jiraJsonBean.getTimeZone()).setActive(jiraJsonBean.isActive()).set_links(userLinks).build();
    }
}

