/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.dto.domain.user;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonAutoDetect
public class CustomerCreateDTO {
    private final String email;
    private final String fullName;

    @JsonCreator
    public CustomerCreateDTO(@JsonProperty(value="email") String email, @JsonProperty(value="fullName") String fullName) {
        this.email = email;
        this.fullName = fullName;
    }

    public String getEmail() {
        return this.email;
    }

    public String getFullName() {
        return this.fullName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(CustomerCreateDTO data) {
        return new Builder(data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomerCreateDTO that = (CustomerCreateDTO)o;
        return Objects.equals(this.getEmail(), that.getEmail()) && Objects.equals(this.getFullName(), that.getFullName());
    }

    public int hashCode() {
        return Objects.hash(this.getEmail(), this.getFullName());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("email", (Object)this.getEmail()).add("fullName", (Object)this.getFullName()).toString();
    }

    public static final class Builder {
        private String email;
        private String fullName;

        private Builder() {
        }

        private Builder(CustomerCreateDTO initialData) {
            this.email = initialData.getEmail();
            this.fullName = initialData.getFullName();
        }

        public Builder setEmail(String email) {
            this.email = email;
            return this;
        }

        public Builder setFullName(String fullName) {
            this.fullName = fullName;
            return this;
        }

        public CustomerCreateDTO build() {
            return new CustomerCreateDTO(this.email, this.fullName);
        }
    }
}

