/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.dto.domain.sla;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.api.rest.dto.domain.date.DateDTOFactory;
import com.atlassian.servicedesk.api.rest.dto.domain.date.DurationDTOFactory;
import com.atlassian.servicedesk.api.rest.dto.domain.sla.SlaInformationCompletedCycleDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.sla.SlaInformationDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.sla.SlaInformationOngoingCycleDTO;
import com.atlassian.servicedesk.api.rest.dto.links.LinkFactory;
import com.atlassian.servicedesk.api.rest.dto.links.SelfLinkDTO;
import com.atlassian.servicedesk.api.sla.info.SlaInformation;
import com.atlassian.servicedesk.api.sla.info.SlaInformationCompletedCycle;
import com.atlassian.servicedesk.api.sla.info.SlaInformationOngoingCycle;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SlaInformationDTOFactory {
    private final LinkFactory linkFactory;
    private final DateDTOFactory dateDtoFactory;
    private final DurationDTOFactory durationDTOFactory;

    @Autowired
    public SlaInformationDTOFactory(LinkFactory linkFactory, DateDTOFactory dateDtoFactory, DurationDTOFactory durationDTOFactory) {
        this.linkFactory = linkFactory;
        this.dateDtoFactory = dateDtoFactory;
        this.durationDTOFactory = durationDTOFactory;
    }

    public Function<SlaInformation, SlaInformationDTO> dtoMapper(ApplicationUser user, String requestIdOrKey) {
        return input -> this.toDTO((SlaInformation)input, user, requestIdOrKey);
    }

    private SlaInformationDTO toDTO(SlaInformation input, ApplicationUser user, String requestIdOrKey) {
        SelfLinkDTO selfLink = this.linkFactory.start().path("request/{requestIdOrKey}/sla/{slaId}").build(requestIdOrKey, input.getId());
        List<SlaInformationCompletedCycleDTO> completedCycles = this.map(input.getCompletedCycles(), cc -> this.toCompletedCycleDTO(user, (SlaInformationCompletedCycle)cc));
        Optional<SlaInformationOngoingCycleDTO> ongoingCycleDTO = input.getOngoingCycle().map(oc -> this.toOngoingCycleDTO(user, (SlaInformationOngoingCycle)oc));
        return SlaInformationDTO.builder().setId(String.valueOf(input.getId())).setName(input.getName()).setCompletedCycles(completedCycles).setOngoingCycle(ongoingCycleDTO.orElse(null)).set_links(selfLink).build();
    }

    private SlaInformationOngoingCycleDTO toOngoingCycleDTO(ApplicationUser user, SlaInformationOngoingCycle input) {
        return SlaInformationOngoingCycleDTO.builder().setBreached(input.getBreached()).setBreachTime(input.getBreachTime().map(bt -> this.dateDtoFactory.toDTO(user, (Instant)bt)).orElse(null)).setElapsedTime(this.durationDTOFactory.toDTO(user, input.getElapsedTime())).setGoalDuration(this.durationDTOFactory.toDTO(user, input.getGoalDuration())).setPaused(input.getPaused()).setRemainingTime(this.durationDTOFactory.toDTO(user, input.getRemainingTime())).setStartTime(this.dateDtoFactory.toDTO(user, input.getStartTime())).setWithinCalendarHours(input.getWithinCalendarHours()).build();
    }

    private SlaInformationCompletedCycleDTO toCompletedCycleDTO(ApplicationUser user, SlaInformationCompletedCycle input) {
        return SlaInformationCompletedCycleDTO.builder().setBreached(input.getBreached()).setElapsedTime(this.durationDTOFactory.toDTO(user, input.getElapsedTime())).setGoalDuration(this.durationDTOFactory.toDTO(user, input.getGoalDuration())).setRemainingTime(this.durationDTOFactory.toDTO(user, input.getRemainingTime())).setStartTime(this.dateDtoFactory.toDTO(user, input.getStartTime())).setStopTime(this.dateDtoFactory.toDTO(user, input.getStopTime())).build();
    }

    private <T, S> List<T> map(List<S> source, Function<S, T> f) {
        return source.stream().map(f::apply).collect(Collectors.toList());
    }
}

