/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.dto.domain.sla;

import com.atlassian.servicedesk.api.rest.dto.domain.sla.SlaInformationCompletedCycleDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.sla.SlaInformationOngoingCycleDTO;
import com.atlassian.servicedesk.api.rest.dto.links.SelfLinkDTO;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonAutoDetect
public class SlaInformationDTO {
    private final String id;
    private final String name;
    private final SelfLinkDTO _links;
    private final List<SlaInformationCompletedCycleDTO> completedCycles;
    @Nullable
    private final SlaInformationOngoingCycleDTO ongoingCycle;

    @JsonCreator
    public SlaInformationDTO(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="_links") SelfLinkDTO _links, @JsonProperty(value="completedCycles") List<SlaInformationCompletedCycleDTO> completedCycles, @JsonProperty(value="ongoingCycle") SlaInformationOngoingCycleDTO ongoingCycle) {
        this.id = id;
        this.name = name;
        this._links = _links;
        this.completedCycles = completedCycles != null ? ImmutableList.copyOf(completedCycles) : null;
        this.ongoingCycle = ongoingCycle;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public SelfLinkDTO get_links() {
        return this._links;
    }

    public List<SlaInformationCompletedCycleDTO> getCompletedCycles() {
        return this.completedCycles;
    }

    public SlaInformationOngoingCycleDTO getOngoingCycle() {
        return this.ongoingCycle;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(SlaInformationDTO data) {
        return new Builder(data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SlaInformationDTO that = (SlaInformationDTO)o;
        return Objects.equals(this.getId(), that.getId()) && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.get_links(), that.get_links()) && Objects.equals(this.getCompletedCycles(), that.getCompletedCycles()) && Objects.equals(this.getOngoingCycle(), that.getOngoingCycle());
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.getName(), this.get_links(), this.getCompletedCycles(), this.getOngoingCycle());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("_links", (Object)this.get_links()).add("completedCycles", this.getCompletedCycles()).add("ongoingCycle", (Object)this.getOngoingCycle()).toString();
    }

    public static final class Builder {
        private String id;
        private String name;
        private SelfLinkDTO _links;
        private List<SlaInformationCompletedCycleDTO> completedCycles = Lists.newArrayList();
        private SlaInformationOngoingCycleDTO ongoingCycle;

        private Builder() {
        }

        private Builder(SlaInformationDTO initialData) {
            this.id = initialData.getId();
            this.name = initialData.getName();
            this._links = initialData.get_links();
            this.completedCycles = Lists.newArrayList(initialData.getCompletedCycles());
            this.ongoingCycle = initialData.getOngoingCycle();
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder set_links(SelfLinkDTO _links) {
            this._links = _links;
            return this;
        }

        public Builder setCompletedCycles(List<SlaInformationCompletedCycleDTO> completedCycles) {
            this.completedCycles = completedCycles;
            return this;
        }

        public Builder addCompletedCycle(SlaInformationCompletedCycleDTO completedCycle) {
            this.completedCycles.add(completedCycle);
            return this;
        }

        public Builder addCompletedCycles(Iterable<SlaInformationCompletedCycleDTO> completedCycles) {
            for (SlaInformationCompletedCycleDTO completedCycle : completedCycles) {
                this.addCompletedCycle(completedCycle);
            }
            return this;
        }

        public Builder setOngoingCycle(SlaInformationOngoingCycleDTO ongoingCycle) {
            this.ongoingCycle = ongoingCycle;
            return this;
        }

        public SlaInformationDTO build() {
            return new SlaInformationDTO(this.id, this.name, this._links, this.completedCycles, this.ongoingCycle);
        }
    }
}

