/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.dto.domain.servicedesk;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.rest.dto.DTOFactory;
import com.atlassian.servicedesk.api.rest.dto.domain.servicedesk.ServiceDeskDTO;
import com.atlassian.servicedesk.api.rest.dto.links.LinkFactory;
import com.atlassian.servicedesk.api.rest.dto.links.SelfLinkDTO;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Suppliers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServiceDeskDTOFactory
implements DTOFactory<ServiceDesk, ServiceDeskDTO> {
    private final LinkFactory linkFactory;
    private final ProjectManager projectManager;

    @Autowired
    public ServiceDeskDTOFactory(LinkFactory linkFactory, ProjectManager projectManager) {
        this.linkFactory = linkFactory;
        this.projectManager = projectManager;
    }

    @Override
    public ServiceDeskDTO toDTO(ServiceDesk from) {
        SelfLinkDTO link = this.linkFactory.start().path("servicedesk").path("{id}").build(from.getId());
        Project project = (Project)Option.option((Object)this.projectManager.getProjectObj(Long.valueOf(from.getProjectId()))).getOrThrow(Suppliers.ofInstance((Object)new RuntimeException("Project cannot be null")));
        return ServiceDeskDTO.builder().setId(String.valueOf(from.getId())).setProjectId(String.valueOf(from.getProjectId())).setProjectName(from.getProjectName()).setProjectKey(project.getKey()).set_links(link).build();
    }
}

