/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.dto.domain.requesttype;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonAutoDetect
public class RequestTypeCreateDTO {
    private final String issueTypeId;
    private final String name;
    private final String description;
    private final String helpText;

    @JsonCreator
    public RequestTypeCreateDTO(@JsonProperty(value="issueTypeId") String issueTypeId, @JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="helpText") String helpText) {
        this.issueTypeId = issueTypeId;
        this.name = name;
        this.description = description;
        this.helpText = helpText;
    }

    public String getIssueTypeId() {
        return this.issueTypeId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getHelpText() {
        return this.helpText;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(RequestTypeCreateDTO data) {
        return new Builder(data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestTypeCreateDTO that = (RequestTypeCreateDTO)o;
        return Objects.equals(this.getIssueTypeId(), that.getIssueTypeId()) && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getDescription(), that.getDescription()) && Objects.equals(this.getHelpText(), that.getHelpText());
    }

    public int hashCode() {
        return Objects.hash(this.getIssueTypeId(), this.getName(), this.getDescription(), this.getHelpText());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("issueTypeId", (Object)this.getIssueTypeId()).add("name", (Object)this.getName()).add("description", (Object)this.getDescription()).add("helpText", (Object)this.getHelpText()).toString();
    }

    public static final class Builder {
        private String issueTypeId;
        private String name;
        private String description;
        private String helpText;

        private Builder() {
        }

        private Builder(RequestTypeCreateDTO initialData) {
            this.issueTypeId = initialData.getIssueTypeId();
            this.name = initialData.getName();
            this.description = initialData.getDescription();
            this.helpText = initialData.getHelpText();
        }

        public Builder setIssueTypeId(String issueTypeId) {
            this.issueTypeId = issueTypeId;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setHelpText(String helpText) {
            this.helpText = helpText;
            return this;
        }

        public RequestTypeCreateDTO build() {
            return new RequestTypeCreateDTO(this.issueTypeId, this.name, this.description, this.helpText);
        }
    }
}

