/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.dto.domain.request;

import com.atlassian.annotations.tenancy.TenancyScope;
import com.atlassian.annotations.tenancy.TenantAware;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonAutoDetect
public class RequestCreateDTO {
    private final String serviceDeskId;
    private final String requestTypeId;
    @TenantAware(value=TenancyScope.TENANTED)
    private final Map<String, Object> requestFieldValues;
    @Nullable
    private final List<String> requestParticipants;
    @Nullable
    private final String raiseOnBehalfOf;

    @JsonCreator
    public RequestCreateDTO(@JsonProperty(value="serviceDeskId") String serviceDeskId, @JsonProperty(value="requestTypeId") String requestTypeId, @JsonProperty(value="requestFieldValues") Map<String, Object> requestFieldValues, @JsonProperty(value="requestParticipants") List<String> requestParticipants, @JsonProperty(value="raiseOnBehalfOf") String raiseOnBehalfOf) {
        this.serviceDeskId = serviceDeskId;
        this.requestTypeId = requestTypeId;
        this.requestFieldValues = requestFieldValues != null ? ImmutableMap.copyOf(requestFieldValues) : null;
        this.requestParticipants = requestParticipants != null ? ImmutableList.copyOf(requestParticipants) : null;
        this.raiseOnBehalfOf = raiseOnBehalfOf;
    }

    public String getServiceDeskId() {
        return this.serviceDeskId;
    }

    public String getRequestTypeId() {
        return this.requestTypeId;
    }

    public Map<String, Object> getRequestFieldValues() {
        return this.requestFieldValues;
    }

    public List<String> getRequestParticipants() {
        return this.requestParticipants;
    }

    public String getRaiseOnBehalfOf() {
        return this.raiseOnBehalfOf;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(RequestCreateDTO data) {
        return new Builder(data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestCreateDTO that = (RequestCreateDTO)o;
        return Objects.equals(this.getServiceDeskId(), that.getServiceDeskId()) && Objects.equals(this.getRequestTypeId(), that.getRequestTypeId()) && Objects.equals(this.getRequestFieldValues(), that.getRequestFieldValues()) && Objects.equals(this.getRequestParticipants(), that.getRequestParticipants()) && Objects.equals(this.getRaiseOnBehalfOf(), that.getRaiseOnBehalfOf());
    }

    public int hashCode() {
        return Objects.hash(this.getServiceDeskId(), this.getRequestTypeId(), this.getRequestFieldValues(), this.getRequestParticipants(), this.getRaiseOnBehalfOf());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("serviceDeskId", (Object)this.getServiceDeskId()).add("requestTypeId", (Object)this.getRequestTypeId()).add("requestFieldValues", this.getRequestFieldValues()).add("requestParticipants", this.getRequestParticipants()).add("raiseOnBehalfOf", (Object)this.getRaiseOnBehalfOf()).toString();
    }

    public static final class Builder {
        private String serviceDeskId;
        private String requestTypeId;
        @TenantAware(value=TenancyScope.TENANTED)
        private Map<String, Object> requestFieldValues = Maps.newHashMap();
        private List<String> requestParticipants = Lists.newArrayList();
        private String raiseOnBehalfOf;

        private Builder() {
        }

        private Builder(RequestCreateDTO initialData) {
            this.serviceDeskId = initialData.getServiceDeskId();
            this.requestTypeId = initialData.getRequestTypeId();
            this.requestFieldValues = Maps.newHashMap(initialData.getRequestFieldValues());
            this.requestParticipants = Lists.newArrayList(initialData.getRequestParticipants());
            this.raiseOnBehalfOf = initialData.getRaiseOnBehalfOf();
        }

        public Builder setServiceDeskId(String serviceDeskId) {
            this.serviceDeskId = serviceDeskId;
            return this;
        }

        public Builder setRequestTypeId(String requestTypeId) {
            this.requestTypeId = requestTypeId;
            return this;
        }

        public Builder setRequestFieldValues(Map<String, Object> requestFieldValues) {
            this.requestFieldValues = requestFieldValues;
            return this;
        }

        public Builder addRequestFieldValues(Map<String, Object> requestFieldValues) {
            this.requestFieldValues.putAll(requestFieldValues);
            return this;
        }

        public Builder setRequestParticipants(List<String> requestParticipants) {
            this.requestParticipants = requestParticipants;
            return this;
        }

        public Builder addRequestParticipant(String requestParticipant) {
            this.requestParticipants.add(requestParticipant);
            return this;
        }

        public Builder addRequestParticipants(Iterable<String> requestParticipants) {
            for (String requestParticipant : requestParticipants) {
                this.addRequestParticipant(requestParticipant);
            }
            return this;
        }

        public Builder setRaiseOnBehalfOf(String raiseOnBehalfOf) {
            this.raiseOnBehalfOf = raiseOnBehalfOf;
            return this;
        }

        public RequestCreateDTO build() {
            return new RequestCreateDTO(this.serviceDeskId, this.requestTypeId, this.requestFieldValues, this.requestParticipants, this.raiseOnBehalfOf);
        }
    }
}

