/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.dto.domain.request;

import com.atlassian.servicedesk.api.rest.dto.links.SelfLinkDTO;
import com.google.common.base.MoreObjects;
import java.net.URI;
import java.util.Objects;
import javax.annotation.Nullable;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonAutoDetect
public class CustomerRequestLinkDTO
extends SelfLinkDTO {
    @Nullable
    private final URI jiraRest;
    private final URI web;

    @JsonCreator
    public CustomerRequestLinkDTO(@JsonProperty(value="jiraRest") URI jiraRest, @JsonProperty(value="web") URI web, @JsonProperty(value="self") URI self) {
        super(self);
        this.jiraRest = jiraRest;
        this.web = web;
    }

    public URI getJiraRest() {
        return this.jiraRest;
    }

    public URI getWeb() {
        return this.web;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(CustomerRequestLinkDTO data) {
        return new Builder(data);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomerRequestLinkDTO that = (CustomerRequestLinkDTO)o;
        return Objects.equals(this.getJiraRest(), that.getJiraRest()) && Objects.equals(this.getWeb(), that.getWeb()) && Objects.equals(this.getSelf(), that.getSelf());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getJiraRest(), this.getWeb(), this.getSelf());
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("jiraRest", (Object)this.getJiraRest()).add("web", (Object)this.getWeb()).add("self", (Object)this.getSelf()).toString();
    }

    public static final class Builder {
        private URI jiraRest;
        private URI web;
        private URI self;

        private Builder() {
        }

        private Builder(CustomerRequestLinkDTO initialData) {
            this.jiraRest = initialData.getJiraRest();
            this.web = initialData.getWeb();
            this.self = initialData.getSelf();
        }

        public Builder setJiraRest(URI jiraRest) {
            this.jiraRest = jiraRest;
            return this;
        }

        public Builder setWeb(URI web) {
            this.web = web;
            return this;
        }

        public Builder setSelf(URI self) {
            this.self = self;
            return this;
        }

        public CustomerRequestLinkDTO build() {
            return new CustomerRequestLinkDTO(this.jiraRest, this.web, this.self);
        }
    }
}

