/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.dto.domain.queue;

import com.atlassian.servicedesk.api.rest.dto.links.Linkable;
import com.atlassian.servicedesk.api.rest.dto.links.SelfLinkDTO;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonAutoDetect
public class QueueDTO
implements Linkable {
    private final String id;
    private final String name;
    private final String jql;
    private final List<String> fields;
    private final Long issueCount;
    private final SelfLinkDTO _links;

    @JsonCreator
    public QueueDTO(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="jql") String jql, @JsonProperty(value="fields") List<String> fields, @JsonProperty(value="issueCount") Long issueCount, @JsonProperty(value="_links") SelfLinkDTO _links) {
        this.id = id;
        this.name = name;
        this.jql = jql;
        this.fields = fields != null ? ImmutableList.copyOf(fields) : null;
        this.issueCount = issueCount;
        this._links = _links;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getJql() {
        return this.jql;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public Long getIssueCount() {
        return this.issueCount;
    }

    public SelfLinkDTO get_links() {
        return this._links;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(QueueDTO data) {
        return new Builder(data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueueDTO that = (QueueDTO)o;
        return Objects.equals(this.getId(), that.getId()) && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getJql(), that.getJql()) && Objects.equals(this.getFields(), that.getFields()) && Objects.equals(this.getIssueCount(), that.getIssueCount()) && Objects.equals(this.get_links(), that.get_links());
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.getName(), this.getJql(), this.getFields(), this.getIssueCount(), this.get_links());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("jql", (Object)this.getJql()).add("fields", this.getFields()).add("issueCount", (Object)this.getIssueCount()).add("_links", (Object)this.get_links()).toString();
    }

    public static final class Builder {
        private String id;
        private String name;
        private String jql;
        private List<String> fields = Lists.newArrayList();
        private Long issueCount;
        private SelfLinkDTO _links;

        private Builder() {
        }

        private Builder(QueueDTO initialData) {
            this.id = initialData.getId();
            this.name = initialData.getName();
            this.jql = initialData.getJql();
            this.fields = Lists.newArrayList(initialData.getFields());
            this.issueCount = initialData.getIssueCount();
            this._links = initialData.get_links();
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setJql(String jql) {
            this.jql = jql;
            return this;
        }

        public Builder setFields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public Builder addField(String field) {
            this.fields.add(field);
            return this;
        }

        public Builder addFields(Iterable<String> fields) {
            for (String field : fields) {
                this.addField(field);
            }
            return this;
        }

        public Builder setIssueCount(Long issueCount) {
            this.issueCount = issueCount;
            return this;
        }

        public Builder set_links(SelfLinkDTO _links) {
            this._links = _links;
            return this;
        }

        public QueueDTO build() {
            return new QueueDTO(this.id, this.name, this.jql, this.fields, this.issueCount, this._links);
        }
    }
}

