/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.dto.domain.organization;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonAutoDetect
public class UsersOrganizationUpdateDTO {
    private final Set<String> usernames;

    @JsonCreator
    public UsersOrganizationUpdateDTO(@JsonProperty(value="usernames") Collection<String> usernames) {
        this.usernames = usernames != null ? ImmutableSet.copyOf(usernames) : null;
    }

    public Set<String> getUsernames() {
        return this.usernames;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(UsersOrganizationUpdateDTO data) {
        return new Builder(data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsersOrganizationUpdateDTO that = (UsersOrganizationUpdateDTO)o;
        return Objects.equals(this.getUsernames(), that.getUsernames());
    }

    public int hashCode() {
        return Objects.hash(this.getUsernames());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("usernames", this.getUsernames()).toString();
    }

    public static final class Builder {
        private Set<String> userNames = Sets.newHashSet();

        private Builder() {
        }

        private Builder(UsersOrganizationUpdateDTO initialData) {
            this.userNames = Sets.newHashSet(initialData.getUsernames());
        }

        public Builder setUserNames(Set<String> userNames) {
            this.userNames = userNames;
            return this;
        }

        public Builder addUserName(String userName) {
            this.userNames.add(userName);
            return this;
        }

        public Builder addUserNames(Iterable<String> userNames) {
            for (String userName : userNames) {
                this.addUserName(userName);
            }
            return this;
        }

        public UsersOrganizationUpdateDTO build() {
            return new UsersOrganizationUpdateDTO(this.userNames);
        }
    }
}

