/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.dto.domain.field;

import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.rest.RestAwareField;
import com.atlassian.jira.rest.api.issue.JsonTypeBean;
import com.atlassian.servicedesk.api.field.RequestTypeField;
import com.atlassian.servicedesk.api.field.RequestTypeFieldValue;
import com.atlassian.servicedesk.api.rest.dto.DTOFactory;
import com.atlassian.servicedesk.api.rest.dto.domain.field.RequestTypeFieldDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.field.RequestTypeFieldValueDTO;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RequestTypeFieldDTOFactory
implements DTOFactory<RequestTypeField, RequestTypeFieldDTO> {
    private final FieldManager fieldManager;

    @Autowired
    public RequestTypeFieldDTOFactory(FieldManager fieldManager) {
        this.fieldManager = fieldManager;
    }

    @Override
    public RequestTypeFieldDTO toDTO(RequestTypeField from) {
        return RequestTypeFieldDTO.builder().setFieldId(from.fieldId().value()).setJiraSchema(this.getSchema(from.fieldId().value())).setName(from.name()).setDescription(from.description()).setRequired(from.required()).setValidValues(Lists.transform((List)from.validValues(), this.asFieldValue())).build();
    }

    private Function<RequestTypeFieldValue, RequestTypeFieldValueDTO> asFieldValue() {
        return input -> RequestTypeFieldValueDTO.builder().setLabel(input.label()).setValue(input.value()).setChildren(Lists.transform((List)input.children(), this.asFieldValue())).build();
    }

    private JsonTypeBean getSchema(String fieldId) {
        return Optional.ofNullable(fieldId).map(field -> this.fieldManager.getField(fieldId)).filter(field -> RestAwareField.class.isAssignableFrom(field.getClass())).map(field -> new JsonTypeBean(((RestAwareField)field).getJsonSchema())).orElse(null);
    }
}

