/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.dto.domain.date;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.api.rest.dto.domain.date.DurationDTO;
import com.atlassian.servicedesk.api.sla.info.SlaInformationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DurationDTOFactory {
    private final SlaInformationService slaInformationService;

    @Autowired
    public DurationDTOFactory(SlaInformationService slaInformationService) {
        this.slaInformationService = slaInformationService;
    }

    public DurationDTO toDTO(ApplicationUser user, Long durationMillis) {
        if (durationMillis == null) {
            return null;
        }
        SlaInformationService.DurationFormatter durationFormatter = this.slaInformationService.getDurationFormatter();
        String friendly = durationFormatter.format(user, durationMillis.longValue());
        return DurationDTO.builder().setMillis(durationMillis).setFriendly(friendly).build();
    }
}

