/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.dto.domain.attachment;

import com.atlassian.servicedesk.api.rest.dto.links.SelfLinkDTO;
import com.google.common.base.MoreObjects;
import java.net.URI;
import java.util.Objects;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonAutoDetect
public class AttachmentLinkDTO
extends SelfLinkDTO {
    private final URI jiraRest;
    private final URI content;
    private final URI thumbnail;

    @JsonCreator
    public AttachmentLinkDTO(@JsonProperty(value="jiraRest") URI jiraRest, @JsonProperty(value="content") URI content, @JsonProperty(value="thumbnail") URI thumbnail, @JsonProperty(value="self") URI self) {
        super(self);
        this.jiraRest = jiraRest;
        this.content = content;
        this.thumbnail = thumbnail;
    }

    public URI getJiraRest() {
        return this.jiraRest;
    }

    public URI getContent() {
        return this.content;
    }

    public URI getThumbnail() {
        return this.thumbnail;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(AttachmentLinkDTO data) {
        return new Builder(data);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttachmentLinkDTO that = (AttachmentLinkDTO)o;
        return Objects.equals(this.getJiraRest(), that.getJiraRest()) && Objects.equals(this.getContent(), that.getContent()) && Objects.equals(this.getThumbnail(), that.getThumbnail()) && Objects.equals(this.getSelf(), that.getSelf());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getJiraRest(), this.getContent(), this.getThumbnail(), this.getSelf());
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("jiraRest", (Object)this.getJiraRest()).add("content", (Object)this.getContent()).add("thumbnail", (Object)this.getThumbnail()).add("self", (Object)this.getSelf()).toString();
    }

    public static final class Builder {
        private URI jiraRest;
        private URI content;
        private URI thumbnail;
        private URI self;

        private Builder() {
        }

        private Builder(AttachmentLinkDTO initialData) {
            this.jiraRest = initialData.getJiraRest();
            this.content = initialData.getContent();
            this.thumbnail = initialData.getThumbnail();
            this.self = initialData.getSelf();
        }

        public Builder setJiraRest(URI jiraRest) {
            this.jiraRest = jiraRest;
            return this;
        }

        public Builder setContent(URI content) {
            this.content = content;
            return this;
        }

        public Builder setThumbnail(URI thumbnail) {
            this.thumbnail = thumbnail;
            return this;
        }

        public Builder setSelf(URI self) {
            this.self = self;
            return this;
        }

        public AttachmentLinkDTO build() {
            return new AttachmentLinkDTO(this.jiraRest, this.content, this.thumbnail, this.self);
        }
    }
}

