/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.dto.domain.attachment;

import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.fields.rest.json.beans.AttachmentJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.AttachmentJsonBeanConverter;
import com.atlassian.servicedesk.api.rest.dto.DTOFactory;
import com.atlassian.servicedesk.api.rest.dto.domain.attachment.AttachmentDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.attachment.AttachmentLinkDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.date.DateDTOFactory;
import com.atlassian.servicedesk.api.rest.dto.domain.user.UserDTOFactory;
import com.atlassian.servicedesk.api.rest.util.uri.UriKit;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AttachmentDTOFactory
implements DTOFactory<Attachment, AttachmentDTO> {
    private final UserDTOFactory userDTOFactory;
    private final DateDTOFactory dateDTOFactory;
    private final UriKit uriKit;
    private final AttachmentJsonBeanConverter attachmentJsonBeanConverter;

    @Autowired
    public AttachmentDTOFactory(UserDTOFactory userDTOFactory, DateDTOFactory dateDTOFactory, UriKit uriKit, AttachmentJsonBeanConverter attachmentJsonBeanConverter) {
        this.userDTOFactory = userDTOFactory;
        this.dateDTOFactory = dateDTOFactory;
        this.uriKit = uriKit;
        this.attachmentJsonBeanConverter = attachmentJsonBeanConverter;
    }

    @Override
    public AttachmentDTO toDTO(Attachment from) {
        AttachmentJsonBean attachmentJsonBean = this.attachmentJsonBeanConverter.shortBean(from);
        String thumbnail = attachmentJsonBean.getThumbnail();
        AttachmentLinkDTO attachmentLinkDTO = AttachmentLinkDTO.builder().setJiraRest(UriKit.toURI(attachmentJsonBean.getSelf())).setContent(this.uriKit.toCustomerURI(attachmentJsonBean.getContent())).setThumbnail(thumbnail != null ? this.uriKit.toCustomerURI(thumbnail) : null).build();
        return AttachmentDTO.builder().setAuthor(this.userDTOFactory.toDTO(from.getAuthorObject())).setCreated(this.dateDTOFactory.toDTO(from.getAuthorObject(), (Date)from.getCreated())).setFilename(from.getFilename()).setMimeType(from.getMimetype()).setSize(from.getFilesize()).set_links(attachmentLinkDTO).build();
    }
}

