/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.dto.domain.attachment;

import com.atlassian.servicedesk.api.rest.dto.domain.attachment.AttachmentLinkDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.date.DateDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.user.UserDTO;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonAutoDetect
public class AttachmentDTO {
    private final String filename;
    private final UserDTO author;
    private final DateDTO created;
    private final long size;
    private final String mimeType;
    private final AttachmentLinkDTO _links;

    @JsonCreator
    public AttachmentDTO(@JsonProperty(value="filename") String filename, @JsonProperty(value="author") UserDTO author, @JsonProperty(value="created") DateDTO created, @JsonProperty(value="size") long size, @JsonProperty(value="mimeType") String mimeType, @JsonProperty(value="_links") AttachmentLinkDTO _links) {
        this.filename = filename;
        this.author = author;
        this.created = created;
        this.size = size;
        this.mimeType = mimeType;
        this._links = _links;
    }

    public String getFilename() {
        return this.filename;
    }

    public UserDTO getAuthor() {
        return this.author;
    }

    public DateDTO getCreated() {
        return this.created;
    }

    public long getSize() {
        return this.size;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public AttachmentLinkDTO get_links() {
        return this._links;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(AttachmentDTO data) {
        return new Builder(data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttachmentDTO that = (AttachmentDTO)o;
        return Objects.equals(this.getFilename(), that.getFilename()) && Objects.equals(this.getAuthor(), that.getAuthor()) && Objects.equals(this.getCreated(), that.getCreated()) && Objects.equals(this.getSize(), that.getSize()) && Objects.equals(this.getMimeType(), that.getMimeType()) && Objects.equals(this.get_links(), that.get_links());
    }

    public int hashCode() {
        return Objects.hash(this.getFilename(), this.getAuthor(), this.getCreated(), this.getSize(), this.getMimeType(), this.get_links());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("filename", (Object)this.getFilename()).add("author", (Object)this.getAuthor()).add("created", (Object)this.getCreated()).add("size", this.getSize()).add("mimeType", (Object)this.getMimeType()).add("_links", (Object)this.get_links()).toString();
    }

    public static final class Builder {
        private String filename;
        private UserDTO author;
        private DateDTO created;
        private long size;
        private String mimeType;
        private AttachmentLinkDTO _links;

        private Builder() {
        }

        private Builder(AttachmentDTO initialData) {
            this.filename = initialData.getFilename();
            this.author = initialData.getAuthor();
            this.created = initialData.getCreated();
            this.size = initialData.getSize();
            this.mimeType = initialData.getMimeType();
            this._links = initialData.get_links();
        }

        public Builder setFilename(String filename) {
            this.filename = filename;
            return this;
        }

        public Builder setAuthor(UserDTO author) {
            this.author = author;
            return this;
        }

        public Builder setCreated(DateDTO created) {
            this.created = created;
            return this;
        }

        public Builder setSize(long size) {
            this.size = size;
            return this;
        }

        public Builder setMimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public Builder set_links(AttachmentLinkDTO _links) {
            this._links = _links;
            return this;
        }

        public AttachmentDTO build() {
            return new AttachmentDTO(this.filename, this.author, this.created, this.size, this.mimeType, this._links);
        }
    }
}

