/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.dto.domain.attachment;

import com.atlassian.servicedesk.api.rest.dto.domain.attachment.AttachmentDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.comment.CommentDTO;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonAutoDetect
public class AttachmentCreateResultDTO {
    private final CommentDTO comment;
    private final List<AttachmentDTO> attachments;

    @JsonCreator
    public AttachmentCreateResultDTO(@JsonProperty(value="comment") CommentDTO comment, @JsonProperty(value="attachments") List<AttachmentDTO> attachments) {
        this.comment = comment;
        this.attachments = attachments != null ? ImmutableList.copyOf(attachments) : null;
    }

    public CommentDTO getComment() {
        return this.comment;
    }

    public List<AttachmentDTO> getAttachments() {
        return this.attachments;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(AttachmentCreateResultDTO data) {
        return new Builder(data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttachmentCreateResultDTO that = (AttachmentCreateResultDTO)o;
        return Objects.equals(this.getComment(), that.getComment()) && Objects.equals(this.getAttachments(), that.getAttachments());
    }

    public int hashCode() {
        return Objects.hash(this.getComment(), this.getAttachments());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("comment", (Object)this.getComment()).add("attachments", this.getAttachments()).toString();
    }

    public static final class Builder {
        private CommentDTO comment;
        private List<AttachmentDTO> attachments = Lists.newArrayList();

        private Builder() {
        }

        private Builder(AttachmentCreateResultDTO initialData) {
            this.comment = initialData.getComment();
            this.attachments = Lists.newArrayList(initialData.getAttachments());
        }

        public Builder setComment(CommentDTO comment) {
            this.comment = comment;
            return this;
        }

        public Builder setAttachments(List<AttachmentDTO> attachments) {
            this.attachments = attachments;
            return this;
        }

        public Builder addAttachment(AttachmentDTO attachment) {
            this.attachments.add(attachment);
            return this;
        }

        public Builder addAttachments(Iterable<AttachmentDTO> attachments) {
            for (AttachmentDTO attachment : attachments) {
                this.addAttachment(attachment);
            }
            return this;
        }

        public AttachmentCreateResultDTO build() {
            return new AttachmentCreateResultDTO(this.comment, this.attachments);
        }
    }
}

