/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.dto.domain.approval;

import com.atlassian.servicedesk.api.rest.dto.domain.approval.ApprovalDecisionResponseType;
import com.atlassian.servicedesk.api.rest.dto.domain.user.UserDTO;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonAutoDetect
public class ApproverDTO {
    private final UserDTO approver;
    private final ApprovalDecisionResponseType approverDecision;

    @JsonCreator
    public ApproverDTO(@JsonProperty(value="approver") UserDTO approver, @JsonProperty(value="approverDecision") ApprovalDecisionResponseType approverDecision) {
        this.approver = approver;
        this.approverDecision = approverDecision;
    }

    public UserDTO getApprover() {
        return this.approver;
    }

    public ApprovalDecisionResponseType getApproverDecision() {
        return this.approverDecision;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ApproverDTO data) {
        return new Builder(data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApproverDTO that = (ApproverDTO)o;
        return Objects.equals(this.getApprover(), that.getApprover()) && Objects.equals((Object)this.getApproverDecision(), (Object)that.getApproverDecision());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getApprover(), this.getApproverDecision()});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("approver", (Object)this.getApprover()).add("approverDecision", (Object)this.getApproverDecision()).toString();
    }

    public static final class Builder {
        private UserDTO approver;
        private ApprovalDecisionResponseType approverDecision;

        private Builder() {
        }

        private Builder(ApproverDTO initialData) {
            this.approver = initialData.getApprover();
            this.approverDecision = initialData.getApproverDecision();
        }

        public Builder setApprover(UserDTO approver) {
            this.approver = approver;
            return this;
        }

        public Builder setApproverDecision(ApprovalDecisionResponseType approverDecision) {
            this.approverDecision = approverDecision;
            return this;
        }

        public ApproverDTO build() {
            return new ApproverDTO(this.approver, this.approverDecision);
        }
    }
}

