/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.dto.domain.approval;

import com.atlassian.fugue.Option;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.api.approval.Approval;
import com.atlassian.servicedesk.api.approval.ApprovalDecisionType;
import com.atlassian.servicedesk.api.approval.Approver;
import com.atlassian.servicedesk.api.rest.dto.domain.approval.ApprovalDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.approval.ApprovalDecisionResponseType;
import com.atlassian.servicedesk.api.rest.dto.domain.approval.ApproverDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.approval.ApproverDTOFactory;
import com.atlassian.servicedesk.api.rest.dto.domain.date.DateDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.date.DateDTOFactory;
import com.atlassian.servicedesk.api.rest.dto.links.LinkFactory;
import com.atlassian.servicedesk.api.rest.dto.links.SelfLinkDTO;
import com.atlassian.servicedesk.api.rest.resource.assembler.ApprovalResponseWrapper;
import java.time.Instant;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApprovalDTOFactory {
    private final DateDTOFactory dateDTOFactory;
    private final ApproverDTOFactory approverDTOFactory;
    private final LinkFactory linkFactory;

    @Autowired
    public ApprovalDTOFactory(DateDTOFactory dateDTOFactory, ApproverDTOFactory approverDTOFactory, LinkFactory linkFactory) {
        this.dateDTOFactory = dateDTOFactory;
        this.approverDTOFactory = approverDTOFactory;
        this.linkFactory = linkFactory;
    }

    public Function<ApprovalResponseWrapper, ApprovalDTO> withUser(ApplicationUser user) {
        return input -> this.toDTO((ApprovalResponseWrapper)input, user);
    }

    private ApprovalDTO toDTO(ApprovalResponseWrapper approvalResponseWrapper, ApplicationUser user) {
        Approval approval = approvalResponseWrapper.getApproval();
        return ApprovalDTO.builder().setId(String.valueOf(approval.getId())).setName(approval.getName()).setFinalDecision(ApprovalDecisionResponseType.resolveToResponseDecision((Option<ApprovalDecisionType>)approval.getDecision())).setCanAnswerApproval(approvalResponseWrapper.isCanAnswerApproval()).setApprovers(this.getApprovers(approvalResponseWrapper.getApprovers())).setCreatedDate(this.dateDTOFactory.toDTO(user, approval.getCreatedDate())).setCompletedDate((DateDTO)approval.getCompletedDate().map(date -> this.dateDTOFactory.toDTO(user, (Instant)date)).getOrNull()).set_links(this.getSelfLink(approval)).build();
    }

    private SelfLinkDTO getSelfLink(Approval approval) {
        return this.linkFactory.start().path("request/{requestId}/approval/{approvalId}").build(approval.getIssueId(), approval.getId());
    }

    private List<ApproverDTO> getApprovers(List<Approver> approvers) {
        return approvers.stream().map(approver -> this.approverDTOFactory.toDTO((Approver)approver)).collect(Collectors.toList());
    }
}

