/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.workinprogressapi.kb;

import com.atlassian.servicedesk.workinprogressapi.kb.KnowledgeBaseSearchQuery;
import javax.annotation.Nonnull;
import org.springframework.util.Assert;

public class KnowledgeBaseSearchQueryBuilder {
    private String query = "";

    public static KnowledgeBaseSearchQuery newQuery(@Nonnull String searchText) {
        return new KnowledgeBaseSearchQueryImpl(searchText);
    }

    @Nonnull
    public KnowledgeBaseSearchQueryBuilder withSearchText(@Nonnull String searchText) {
        Assert.notNull((Object)searchText);
        this.query = searchText;
        return this;
    }

    @Nonnull
    public KnowledgeBaseSearchQuery build() {
        return new KnowledgeBaseSearchQueryImpl(this.query);
    }

    private static class KnowledgeBaseSearchQueryImpl
    implements KnowledgeBaseSearchQuery {
        private final String query;

        public KnowledgeBaseSearchQueryImpl(@Nonnull String query) {
            Assert.notNull((Object)query, (String)"query cannot be null");
            this.query = query;
        }

        @Override
        @Nonnull
        public String getSearchText() {
            return this.query;
        }
    }
}

