/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.workflow.importer;

import com.atlassian.jira.plugins.workflow.sharing.importer.component.WorkflowBundle;
import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

@VisibleForTesting
class WorkflowBundleProxy
implements InvocationHandler {
    private final WorkflowBundle rawBundle;
    private final String processedXml;

    public static WorkflowBundle createProxy(WorkflowBundle rawBundle, String processedXml) {
        return (WorkflowBundle)Proxy.newProxyInstance(WorkflowBundleProxy.class.getClassLoader(), new Class[]{WorkflowBundle.class}, (InvocationHandler)new WorkflowBundleProxy(rawBundle, processedXml));
    }

    private WorkflowBundleProxy(WorkflowBundle rawBundle, String processedXml) {
        this.rawBundle = rawBundle;
        this.processedXml = processedXml;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if ("getWorkflowXml".equals(method.getName()) && method.getParameterTypes().length == 0) {
            return this.processedXml;
        }
        if (Object.class.getDeclaredMethod("toString", new Class[0]).equals(method)) {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
        if (Object.class.getDeclaredMethod("equals", Object.class).equals(method)) {
            return this.equals(args[0]);
        }
        if (Object.class.getDeclaredMethod("hashCode", new Class[0]).equals(method)) {
            return this.hashCode();
        }
        return method.invoke((Object)this.rawBundle, args);
    }
}

