/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.workflow.importer;

import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.plugins.workflow.sharing.importer.component.DefaultWorkflowBundleFactory;
import com.atlassian.jira.plugins.workflow.sharing.importer.component.WorkflowBundle;
import com.atlassian.jira.plugins.workflow.sharing.servlet.ValidationException;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.servicedesk.internal.workflow.importer.I18nWorkflowXmlProcessor;
import com.atlassian.servicedesk.internal.workflow.importer.WorkflowBundleProxy;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class I18nAwareWorkflowBundleFactory {
    private final WorkflowBundle.Factory bundleFactory;
    private final JiraProperties jiraProperties;
    private final I18nWorkflowXmlProcessor i18nWorkflowXmlProcessor;

    @Autowired
    public I18nAwareWorkflowBundleFactory(I18nResolver i18nResolver, JiraProperties jiraProperties) {
        this.jiraProperties = jiraProperties;
        this.i18nWorkflowXmlProcessor = new I18nWorkflowXmlProcessor();
        this.bundleFactory = new DefaultWorkflowBundleFactory(i18nResolver);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WorkflowBundle loadBundle(I18nHelper serverI18n, String classPathToBundle) {
        WorkflowBundle workflowBundle;
        InputStream resourceAsStream = null;
        try {
            resourceAsStream = this.getClass().getResourceAsStream(classPathToBundle);
            WorkflowBundle rawBundle = this.bundleFactory.bundle(resourceAsStream, WorkflowBundle.BundleSource.MANUAL);
            String processedXml = this.i18nWorkflowXmlProcessor.process(serverI18n, rawBundle.getWorkflowXml());
            this.debugXML(processedXml);
            workflowBundle = WorkflowBundleProxy.createProxy(rawBundle, processedXml);
        }
        catch (ValidationException e) {
            try {
                throw new RuntimeException(e);
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(resourceAsStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)resourceAsStream);
        return workflowBundle;
    }

    private void debugXML(String processedXml) {
        if (this.jiraProperties.isDevMode()) {
            try {
                File tempFile = File.createTempFile("workflowImport", ".xml");
                FileWriter fw = new FileWriter(tempFile);
                fw.write(processedXml);
                fw.close();
                System.out.println(processedXml);
                System.out.println("\nImported XML as : " + tempFile + "\n");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

