/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.webfragments;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.web.api.DynamicWebInterfaceManager;
import com.atlassian.plugin.web.api.WebItem;
import com.atlassian.plugin.web.api.WebSection;
import com.atlassian.plugin.web.model.WebPanel;
import com.atlassian.servicedesk.internal.api.webfragments.WebInterfaceBeanService;
import com.atlassian.servicedesk.internal.api.webfragments.WebItemBean;
import com.atlassian.servicedesk.internal.api.webfragments.WebPanelBean;
import com.atlassian.servicedesk.internal.api.webfragments.WebSectionBean;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class WebInterfaceBeanServiceImpl
implements WebInterfaceBeanService {
    private DynamicWebInterfaceManager webInterfaceManager;

    @Autowired
    public WebInterfaceBeanServiceImpl(DynamicWebInterfaceManager webInterfaceManager) {
        this.webInterfaceManager = webInterfaceManager;
    }

    public List<WebSectionBean> getWebSections(String location, Map<String, Object> context) {
        Iterable displayableWebSections = this.webInterfaceManager.getDisplayableWebSections(location, context);
        ArrayList webSections = Lists.newArrayList();
        for (WebSection webSection : displayableWebSections) {
            webSections.add(new WebSectionBean(webSection, this.getWebItems(webSection.getId(), context)));
        }
        return webSections;
    }

    public List<WebPanelBean> getWebPanels(String location, Map<String, Object> context) {
        return this.webInterfaceManager.getDisplayableWebPanelDescriptors(location, context).stream().map(panelDescriptor -> new WebPanelBean(panelDescriptor, ((WebPanel)panelDescriptor.getModule()).getHtml(context))).collect(Collectors.toList());
    }

    public List<WebItemBean> getWebItems(String location, Map<String, Object> context) {
        Iterable displayableWebItems = this.webInterfaceManager.getDisplayableWebItems(location, context);
        ArrayList webItems = Lists.newArrayList();
        for (WebItem webItem : displayableWebItems) {
            String path = this.getNestedWebItemKey(location, webItem);
            List<WebItemBean> nestedWebItems = this.getWebItems(path, context);
            webItems.add(new WebItemBean(webItem, nestedWebItems));
        }
        return webItems;
    }

    private String getNestedWebItemKey(String location, WebItem webItem) {
        String webItemKey = webItem.getCompleteKey();
        if (webItemKey.contains(":")) {
            webItemKey = webItem.getCompleteKey().split(":")[1];
        }
        return location + "/" + webItemKey;
    }
}

