/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.web.shim;

import com.atlassian.servicedesk.internal.feature.customer.request.CustomerViewableAttachmentService;
import io.atlassian.fugue.Option;
import java.io.IOException;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.LongStream;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RequestAttachmentPermissionService {
    private static final String ISSUE_ID_PARAM = "fromIssue";
    private static final Pattern ATTACHMENT_ID_PATTERN = Pattern.compile("secure\\/.+\\/(\\d+)\\/");
    private final CustomerViewableAttachmentService customerViewableAttachmentService;

    @Autowired
    public RequestAttachmentPermissionService(CustomerViewableAttachmentService customerViewableAttachmentService) {
        this.customerViewableAttachmentService = customerViewableAttachmentService;
    }

    public boolean customerCanViewAttachment(long issueId, long requestedAttachmentId) throws IOException {
        return ((LongStream)this.customerViewableAttachmentService.getViewableAttachments(issueId).getOrElse((Object)LongStream.empty())).anyMatch(attachmentId -> Objects.equals(attachmentId, requestedAttachmentId));
    }

    Option<Long> getIssueIdFromRequest(HttpServletRequest request) {
        return this.getLongOrNone(request.getParameter(ISSUE_ID_PARAM));
    }

    Option<Long> getAttachmentIdFromURI(String requestURI) {
        Matcher m = ATTACHMENT_ID_PATTERN.matcher(requestURI);
        if (m.find()) {
            return this.getLongOrNone(m.group(1));
        }
        return Option.none();
    }

    private Option<Long> getLongOrNone(String value) {
        try {
            return Option.some((Object)Long.parseLong(value));
        }
        catch (NumberFormatException e) {
            return Option.none();
        }
    }

    public boolean isAttachmentUrl(String toURI) {
        return toURI.startsWith("/secure/attachment") || toURI.startsWith("/secure/thumbnail");
    }
}

