/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.web.shim;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.servicedesk.internal.api.condition.SDOperationalConditionHelper;
import com.atlassian.servicedesk.internal.utils.CustomerUrlUtil;
import com.atlassian.servicedesk.internal.web.OperationalStatusAwareHttpFilter;
import com.atlassian.servicedesk.internal.web.shim.RequestAttachmentPermissionService;
import io.atlassian.fugue.Option;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.HashMap;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class CustomerPortalShim
extends OperationalStatusAwareHttpFilter {
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final CustomerUrlUtil customerUrlUtil;
    private final ApplicationProperties applicationProperties;
    private final RequestAttachmentPermissionService requestAttachmentPermissionService;

    @Autowired
    public CustomerPortalShim(JiraAuthenticationContext jiraAuthenticationContext, CustomerUrlUtil customerUrlUtil, ApplicationProperties applicationProperties, SDOperationalConditionHelper sdOperationalConditionHelper, RequestAttachmentPermissionService requestAttachmentPermissionService) {
        super(sdOperationalConditionHelper);
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.customerUrlUtil = customerUrlUtil;
        this.applicationProperties = applicationProperties;
        this.requestAttachmentPermissionService = requestAttachmentPermissionService;
    }

    @Override
    protected void doFilterWhenLicensed(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        String fromURI = request.getRequestURI();
        String toURI = fromURI.substring(fromURI.lastIndexOf("/servicedesk/customershim") + "/servicedesk/customershim".length());
        if (!this.checkValidUri(toURI)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else if (this.jiraAuthenticationContext.isLoggedInUser()) {
            this.handleRequest(request, response, toURI);
        } else {
            String queryString = request.getQueryString();
            this.redirectToCustomerLoginPage(response, StringUtils.isNotBlank((String)queryString) ? fromURI + "?" + queryString : fromURI);
        }
    }

    private void handleRequest(HttpServletRequest request, HttpServletResponse response, String toURI) throws IOException, ServletException {
        if (this.requestAttachmentPermissionService.isAttachmentUrl(toURI)) {
            Option<Long> issueIdOption = this.requestAttachmentPermissionService.getIssueIdFromRequest(request);
            Option<Long> requestedAttachmentIdOption = this.requestAttachmentPermissionService.getAttachmentIdFromURI(request.getRequestURI());
            if (issueIdOption.isEmpty() || requestedAttachmentIdOption.isEmpty()) {
                response.sendError(400);
                return;
            }
            if (!this.requestAttachmentPermissionService.customerCanViewAttachment((Long)issueIdOption.get(), (Long)requestedAttachmentIdOption.get())) {
                response.sendError(403);
                return;
            }
        }
        request.getRequestDispatcher(toURI).forward((ServletRequest)request, (ServletResponse)response);
    }

    private boolean checkValidUri(String uri) {
        return CustomerUrlUtil.SHIM_WHITE_LIST.stream().anyMatch(uri::startsWith);
    }

    private void redirectToCustomerLoginPage(HttpServletResponse response, String requestedUri) throws IOException {
        String encodedPath = URLEncoder.encode(requestedUri, this.applicationProperties.getEncoding());
        HashMap<String, String> loginMap = new HashMap<String, String>();
        loginMap.put("destination", encodedPath);
        loginMap.put("absolute", "true");
        String customerLoginPageUri = this.customerUrlUtil.getLoginUrl(loginMap, false);
        response.setHeader("Cache-Control", "no-cache");
        response.setStatus(307);
        response.setHeader("Location", customerLoginPageUri);
    }
}

