/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.web.pagedata;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.internal.api.license.ServiceDeskApplicationLicenseService;
import com.atlassian.servicedesk.internal.api.user.permission.ServiceDeskLicenseAndPermissionService;
import com.atlassian.servicedesk.internal.rest.responses.AgentResponse;
import io.atlassian.fugue.Either;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AgentEntityBuilder {
    private final AvatarService avatarService;
    private final ServiceDeskLicenseAndPermissionService licenseAndPermissionService;
    private final ServiceDeskApplicationLicenseService applicationLicenseService;

    @Autowired
    public AgentEntityBuilder(AvatarService avatarService, ServiceDeskLicenseAndPermissionService licenseAndPermissionService, ServiceDeskApplicationLicenseService applicationLicenseService) {
        this.avatarService = avatarService;
        this.licenseAndPermissionService = licenseAndPermissionService;
        this.applicationLicenseService = applicationLicenseService;
    }

    public boolean showAgentLicenseCapacity() {
        return !this.applicationLicenseService.isAgentLicenseCapacityUnlimited();
    }

    public Either<AnError, List<AgentResponse>> buildAgentResponses(List<CheckedUser> agents) {
        return Either.right(agents.stream().map(this::buildAgentResponse).collect(Collectors.toList()));
    }

    AgentResponse buildAgentResponse(CheckedUser agent) {
        return AgentResponse.build(agent, this.licenseAndPermissionService.canAdministerJIRA((SDUser)agent), this.getAvatarUrls(agent));
    }

    private AgentResponse.AvatarUrls getAvatarUrls(CheckedUser agent) {
        return new AgentResponse.AvatarUrls(this.avatarService.getAvatarURL(agent.forJIRA(), agent.forJIRA(), Avatar.Size.SMALL).toString(), this.avatarService.getAvatarURL(agent.forJIRA(), agent.forJIRA(), Avatar.Size.MEDIUM).toString(), this.avatarService.getAvatarURL(agent.forJIRA(), agent.forJIRA(), Avatar.Size.LARGE).toString());
    }
}

