/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.web.contextprovider;

import com.atlassian.fugue.Either;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.ServiceDeskService;
import com.atlassian.servicedesk.api.permission.ServiceDeskPermissionService;
import com.atlassian.servicedesk.internal.api.project.ProjectUrlsProvider;
import com.atlassian.servicedesk.internal.api.webfragments.ConnectContextKeyMappings;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServiceDeskProjectContextProvider {
    private JiraAuthenticationContext jiraAuthenticationContext;
    private ProjectUrlsProvider projectUrlProvider;
    private final ServiceDeskPermissionService serviceDeskPermissionService;
    private final ProjectService projectService;
    private final ServiceDeskService serviceDeskService;

    @Autowired
    public ServiceDeskProjectContextProvider(JiraAuthenticationContext jiraAuthenticationContext, ProjectUrlsProvider projectUrlProvider, ServiceDeskPermissionService serviceDeskPermissionService, ProjectService projectService, ServiceDeskService serviceDeskService) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.projectUrlProvider = projectUrlProvider;
        this.serviceDeskPermissionService = serviceDeskPermissionService;
        this.projectService = projectService;
        this.serviceDeskService = serviceDeskService;
    }

    public Map<String, Object> getContextMap(String projectKey) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        context.put("projectKey", projectKey);
        context.put("projectUrls", this.projectUrlProvider.getUrls(projectKey, ProjectUrlsProvider.UrlMode.RELATIVE));
        if (user != null) {
            context.put("user", user);
            ProjectService.GetProjectResult projectResult = this.projectService.getProjectByKey(user, projectKey);
            if (projectResult.isValid()) {
                Project project = projectResult.getProject();
                context.put("project", project);
                context.put("projectId", project.getId());
                io.atlassian.fugue.Either serviceDeskResult = StepsConverters.newerEither((Either)this.serviceDeskService.getServiceDeskForProject(user, project));
                if (serviceDeskResult.isRight()) {
                    ServiceDesk serviceDesk = (ServiceDesk)serviceDeskResult.right().get();
                    context.put("serviceDesk", serviceDesk);
                    context.put(ConnectContextKeyMappings.SERVICE_DESK_ID.getUiKey(), serviceDesk.getId());
                    io.atlassian.fugue.Either isAdminResult = StepsConverters.newerEither((Either)this.serviceDeskPermissionService.isAdminAgent(user, serviceDesk));
                    context.put("isAdmin", isAdminResult.right().getOrElse((Object)false));
                }
            }
        }
        return context;
    }
}

