/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.web;

import com.atlassian.servicedesk.internal.api.condition.SDOperationalConditionHelper;
import com.atlassian.servicedesk.internal.customer.context.urimatching.UriMatch;
import com.atlassian.servicedesk.internal.customer.context.urimatching.UriMatcher;
import com.atlassian.servicedesk.internal.web.OperationalStatusAwareHttpFilter;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class UrlOperationalStatusCheckFilter
extends OperationalStatusAwareHttpFilter {
    private final UriMatcher SD_URI_WHITE_LIST = new UriMatcher((ImmutableList<UriMatch>)ImmutableList.of((Object)UriMatch.builder().startsWith("/rest").addPattern("/servicedeskapi/info").addPattern("/servicedesk/always/.*").build()));

    public UrlOperationalStatusCheckFilter(SDOperationalConditionHelper sdOperationalConditionHelper) {
        super(sdOperationalConditionHelper);
    }

    @Override
    protected void doFilterWhenLicensed(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    @Override
    protected void doFilterWhenNotLicensed(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        String contextPath = request.getContextPath();
        String requestPath = request.getRequestURI().replace(contextPath, "");
        if (UriMatcher.Decision.GRANTED == this.SD_URI_WHITE_LIST.matches(requestPath)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else {
            response.sendError(403, "JIRA Service Desk is not licensed");
        }
    }
}

