/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.web;

import com.atlassian.servicedesk.internal.api.project.ProjectUrls;
import java.net.URI;
import javax.ws.rs.core.UriBuilder;

public class ProjectUrlsImpl
implements ProjectUrls {
    private final URI projectUri;
    private final URI settingsUri;

    public ProjectUrlsImpl(URI projectUri, URI settingsUri) {
        this.projectUri = projectUri;
        this.settingsUri = settingsUri;
    }

    public URI projectBase() {
        return this.projectUri;
    }

    public URI queues() {
        return UriBuilder.fromUri((URI)this.projectUri).path("queues").build(new Object[0]);
    }

    public URI customQueue(String id) {
        return UriBuilder.fromUri((URI)this.queues()).path("custom").path(id).build(new Object[0]);
    }

    public URI issue(String issueKey) {
        return UriBuilder.fromUri((URI)this.projectUri).path("issue").path(issueKey).build(new Object[0]);
    }

    public URI projectSettings() {
        return this.settingsUri;
    }

    public URI requestTypeSettings() {
        return this.requestTypeBaseUri().build(new Object[0]);
    }

    public URI requestTypeSettings(String id) {
        return this.requestTypeBaseUri().path("group").path(id).build(new Object[0]);
    }

    public URI portalSettings() {
        return UriBuilder.fromUri((URI)this.projectSettings()).path("portal-settings").build(new Object[0]);
    }

    public URI participantsSettings() {
        return UriBuilder.fromUri((URI)this.projectSettings()).path("participants").build(new Object[0]);
    }

    public URI requestSecuritySettings() {
        return UriBuilder.fromUri((URI)this.projectSettings()).path("request-security").build(new Object[0]);
    }

    public URI feedbackSettings() {
        return UriBuilder.fromUri((URI)this.projectSettings()).path("feedback-settings").build(new Object[0]);
    }

    public URI emailSettings() {
        return UriBuilder.fromUri((URI)this.projectSettings()).path("email-settings").build(new Object[0]);
    }

    public URI manageAgents() {
        throw new IllegalStateException("When roles are enabled, there is no manage agents page. This is not the URI you are looking for.");
    }

    public URI themeSettings() {
        return UriBuilder.fromUri((URI)this.projectSettings()).path("lookandfeel").build(new Object[0]);
    }

    public URI kbSettings() {
        return UriBuilder.fromUri((URI)this.projectSettings()).path("confluence-kb").build(new Object[0]);
    }

    public URI automationSettings() {
        return UriBuilder.fromUri((URI)this.projectSettings()).path("automation").build(new Object[0]);
    }

    public URI slaSettings() {
        return UriBuilder.fromUri((URI)this.projectSettings()).path("sla").build(new Object[0]);
    }

    public URI slaSettings(String id) {
        return UriBuilder.fromUri((URI)this.slaSettings()).path("custom").path(id).build(new Object[0]);
    }

    public URI reports() {
        return UriBuilder.fromUri((URI)this.projectUri).path("reports").build(new Object[0]);
    }

    public URI slaReport() {
        return UriBuilder.fromUri((URI)this.reports()).path("sla").build(new Object[0]);
    }

    public URI workloadReport() {
        return UriBuilder.fromUri((URI)this.reports()).path("workload").build(new Object[0]);
    }

    public URI customReport(String id) {
        return UriBuilder.fromUri((URI)this.reports()).path("custom").path(id).build(new Object[0]);
    }

    public URI customReport(String id, String timeScale) {
        return UriBuilder.fromUri((URI)this.projectUri).path("timescale").path(timeScale).build(new Object[0]);
    }

    public URI reportAllRating() {
        return UriBuilder.fromUri((URI)this.reports()).path("all-rating").build(new Object[0]);
    }

    public URI issues() {
        return UriBuilder.fromUri((URI)this.projectUri).path("issues").build(new Object[0]);
    }

    public URI customers() {
        return UriBuilder.fromUri((URI)this.projectUri).path("customers").build(new Object[0]);
    }

    public URI welcomeGuide() {
        return UriBuilder.fromUri((URI)this.projectUri).path("welcome-guide").build(new Object[0]);
    }

    private UriBuilder requestTypeBaseUri() {
        return UriBuilder.fromUri((URI)this.projectSettings()).path("request-types");
    }
}

