/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.web;

import com.atlassian.servicedesk.internal.api.project.PortalUrls;
import java.net.URI;
import javax.annotation.Nonnull;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang.Validate;

public class PortalUrlsImpl
implements PortalUrls {
    private final URI helpCentreBase;
    private final URI portalBase;

    public PortalUrlsImpl(URI helpCentreBase) {
        this.helpCentreBase = helpCentreBase;
        this.portalBase = null;
    }

    public PortalUrlsImpl(URI helpCentreBase, URI portalBase) {
        this.helpCentreBase = helpCentreBase;
        this.portalBase = portalBase;
    }

    public URI helpCentre() {
        return UriBuilder.fromUri((URI)this.helpCentreBase).build(new Object[0]);
    }

    public URI portal() {
        if (this.portalBase == null) {
            throw new IllegalStateException("Trying to access the portal url without giving us a valid portal to look at");
        }
        return UriBuilder.fromUri((URI)this.portalBase).build(new Object[0]);
    }

    public URI request(@Nonnull String issueKey) {
        if (this.portalBase == null) {
            throw new IllegalStateException("Trying to access the portal url without giving us a valid portal to look at");
        }
        Validate.notNull((Object)issueKey, (String)"Cannot access a portal request without a valid issueKey");
        return UriBuilder.fromUri((URI)this.portalBase).path(issueKey).build(new Object[0]);
    }

    public URI feedback(@Nonnull String issueKey, @Nonnull String token) {
        if (this.portalBase == null) {
            throw new IllegalStateException("Trying to access the portal url without giving us a valid portal to look at");
        }
        Validate.notNull((Object)issueKey, (String)"Cannot access a portal feedback url without a valid issueKey");
        Validate.notNull((Object)token, (String)"Cannot access unique feedback url without a valid token");
        return UriBuilder.fromUri((URI)this.portalBase).path(issueKey).path("feedback").queryParam("token", new Object[]{token}).build(new Object[0]);
    }

    public URI unsubscribe(@Nonnull String issueKey) {
        if (this.portalBase == null) {
            throw new IllegalStateException("Trying to create the portal url without valid portal");
        }
        Validate.notNull((Object)issueKey, (String)"Cannot create a portal unsubscribe url without a valid issueKey");
        return UriBuilder.fromUri((URI)this.portalBase).path(issueKey).path("unsubscribe").build(new Object[0]);
    }

    public URI unsubscribe(@Nonnull String issueKey, @Nonnull String jwtToken) {
        if (this.portalBase == null) {
            throw new IllegalStateException("Trying to create the portal url without valid portal");
        }
        Validate.notNull((Object)issueKey, (String)"Cannot create a portal unsubscribe url without a valid issueKey");
        Validate.notNull((Object)jwtToken, (String)"Cannot create a portal unsubscribe url without a valid jwtToken");
        return UriBuilder.fromUri((URI)this.portalBase).path(issueKey).path("unsubscribe").queryParam("jwt", new Object[]{jwtToken}).build(new Object[0]);
    }
}

