/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.web;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.datetime.DateTimeFormatUtils;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.servicedesk.internal.web.CalendarControlSettings;
import com.atlassian.servicedesk.internal.web.CalendarWebResourcesUtil;
import com.atlassian.servicedesk.internal.web.LanguageSpecificCalendarResourceProvider;
import com.atlassian.webresource.api.assembler.WebResourceAssembler;
import java.util.Calendar;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LanguageSpecificCalendarResourceProviderImpl
implements LanguageSpecificCalendarResourceProvider {
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final CalendarWebResourcesUtil calendarWebResourcesUtil;
    private final ApplicationProperties applicationProperties;
    private final DateTimeFormatter dateTimeFormatter;

    @Autowired
    public LanguageSpecificCalendarResourceProviderImpl(JiraAuthenticationContext jiraAuthenticationContext, CalendarWebResourcesUtil calendarWebResourcesUtil, ApplicationProperties applicationProperties, DateTimeFormatter dateTimeFormatter) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.calendarWebResourcesUtil = calendarWebResourcesUtil;
        this.applicationProperties = applicationProperties;
        this.dateTimeFormatter = dateTimeFormatter;
    }

    @Override
    public void addResources(WebResourceAssembler assembler) {
        this.calendarWebResourcesUtil.getPortalCalendarWebResources(this.jiraAuthenticationContext.getLocale()).stream().forEach(webResourceKey -> assembler.resources().requireWebResource(webResourceKey));
    }

    @Override
    public CalendarControlSettings getParams() {
        LazyCalendarEmulator currentCalendar = new LazyCalendarEmulator();
        DateTimeFormatter dateFormatter = this.dateTimeFormatter.withStyle(DateTimeStyle.COMPLETE).forLoggedInUser();
        DateTimeFormatter iso8601Formatter = dateFormatter.withStyle(DateTimeStyle.ISO_8601_DATE_TIME);
        int firstDay = currentCalendar.getFirstDayOfWeek();
        return new CalendarControlSettings(firstDay - 1, iso8601Formatter.format(new Date()), currentCalendar.isUseISO8601(), DateTimeFormatUtils.getDateFormat(), DateTimeFormatUtils.getDateTimeFormat(), DateTimeFormatUtils.getTimeFormat());
    }

    private class LazyCalendarEmulator {
        Calendar calendar;

        private LazyCalendarEmulator() {
            this.calendar = Calendar.getInstance(LanguageSpecificCalendarResourceProviderImpl.this.jiraAuthenticationContext.getLocale());
        }

        public boolean isUseISO8601() {
            return LanguageSpecificCalendarResourceProviderImpl.this.applicationProperties.getOption("jira.date.time.picker.use.iso8061");
        }

        public int getFirstDayOfWeek() {
            return this.calendar.getFirstDayOfWeek();
        }
    }
}

