/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.web;

import com.atlassian.core.filters.AbstractHttpFilter;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.internal.api.condition.SDOperationalConditionHelper;
import com.atlassian.servicedesk.internal.user.external.ExternalCustomerAccessService;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ExternalCustomerLockoutFilter
extends AbstractHttpFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalCustomerLockoutFilter.class);
    private final ExternalCustomerAccessService externalCustomerAccessService;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final SDOperationalConditionHelper sdOperationalConditionHelper;

    @Autowired
    public ExternalCustomerLockoutFilter(ExternalCustomerAccessService externalCustomerAccessService, JiraAuthenticationContext jiraAuthenticationContext, SDOperationalConditionHelper sdOperationalConditionHelper) {
        this.externalCustomerAccessService = externalCustomerAccessService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.sdOperationalConditionHelper = sdOperationalConditionHelper;
    }

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (this.currentUserCanExecuteRequest(request) || !this.sdOperationalConditionHelper.isConditionTrue()) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else {
            LOGGER.debug("Could not execute request. Redirecting to lost page.");
            String contextPath = request.getContextPath();
            String redirectUrl = this.externalCustomerAccessService.generateRedirectUrl(request);
            response.sendRedirect(contextPath + redirectUrl);
        }
    }

    private boolean currentUserCanExecuteRequest(HttpServletRequest request) {
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        return this.externalCustomerAccessService.canExecuteRequest(user, request);
    }
}

