/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.web;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.web.action.util.CalendarLanguageUtil;
import com.atlassian.servicedesk.internal.web.CalendarWebResourcesUtil;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CalendarWebResourcesUtilImpl
implements CalendarWebResourcesUtil {
    private static final String CALENDAR_RESOURCE_KEY = "jira.webresources:calendar";
    private static final String CALENDAR_LOCALISATION_RESOURCE_PREFIX = "jira.webresources:calendar-";
    private static final String CALENDAR_LOCALISATION_MOMENT_JS_RESOURCE_KEY = "jira.webresources:calendar-localisation-moment";
    private static final String DEFAULT_LANG = "en";
    private static final String OBSOLETE_HEBREW_LANGUAGE_CODE = "iw";
    private static final String CURRENT_HEBREW_LANGUAGE_CODE = "he";
    private static final String UNSUPPORTED = "unsupported";
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final CalendarLanguageUtil calendarLanguageUtil;

    @Autowired
    public CalendarWebResourcesUtilImpl(JiraAuthenticationContext jiraAuthenticationContext, CalendarLanguageUtil calendarLanguageUtil) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.calendarLanguageUtil = calendarLanguageUtil;
    }

    @Override
    public List<String> getPortalCalendarWebResources() {
        return this.getPortalCalendarWebResources(this.jiraAuthenticationContext.getLocale());
    }

    @Override
    public List<String> getPortalCalendarWebResources(Locale locale) {
        return ImmutableList.of((Object)CALENDAR_RESOURCE_KEY, (Object)this.getLocaleWebResource(this.getLanguageCode(locale)));
    }

    @Override
    public List<String> getJiraCalendarWebResources() {
        return this.getJiraCalendarWebResources(this.jiraAuthenticationContext.getLocale());
    }

    @Override
    public List<String> getJiraCalendarWebResources(Locale locale) {
        return ImmutableList.of((Object)CALENDAR_RESOURCE_KEY, (Object)this.getLocaleWebResource(this.getLanguageCode(locale)), (Object)CALENDAR_LOCALISATION_MOMENT_JS_RESOURCE_KEY);
    }

    private String getLanguageCode(Locale locale) {
        if (locale == null) {
            return UNSUPPORTED;
        }
        String languageCode = locale.getLanguage();
        if (OBSOLETE_HEBREW_LANGUAGE_CODE.equals(languageCode)) {
            languageCode = CURRENT_HEBREW_LANGUAGE_CODE;
        }
        return languageCode;
    }

    private String getLocaleWebResource(String lang) {
        if (this.calendarLanguageUtil.hasTranslationForLanguage(lang)) {
            return CALENDAR_LOCALISATION_RESOURCE_PREFIX + lang;
        }
        return "jira.webresources:calendar-en";
    }
}

