/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.visiblefortesting;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.customfields.manager.GenericConfigManager;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldValuePersister;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.atlassian.jira.web.bean.BulkEditBeanImpl;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.servicedesk.api.request.ServiceDeskCustomerRequestService;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.customfields.origin.VpOriginCustomFieldService;
import com.atlassian.servicedesk.internal.api.project.InternalServiceDeskProjectManager;
import com.atlassian.servicedesk.internal.api.util.SoyTemplateRenderer;
import com.atlassian.servicedesk.internal.api.visiblefortesting.VpOriginBackdoor;
import com.atlassian.servicedesk.internal.customfields.SDCustomfieldBulkEditSecurityHelper;
import com.atlassian.servicedesk.internal.customfields.origin.VpOriginCFType;
import com.atlassian.servicedesk.internal.customfields.origin.VpOriginManager;
import com.atlassian.servicedesk.internal.customfields.util.FieldJsonBuilderAccessor;
import com.atlassian.servicedesk.internal.feature.customer.portal.InternalPortalService;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.RequestTypeInternalServiceImpl;
import io.atlassian.fugue.Option;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
@Internal
public class VpOriginBackdoorImpl
implements VpOriginBackdoor {
    private final VpOriginManager vpOriginManager;
    private final RequestTypeInternalServiceImpl requestTypeInternalServiceImpl;
    private final UserFactory userFactory;
    private final IssueManager issueManager;
    private final I18nHelper i18nHelper;
    private final ErrorResultHelper errorResultHelper;
    private final CustomFieldValuePersister customFieldValuePersister;
    private final GenericConfigManager genericConfigManager;
    private final InternalServiceDeskProjectManager internalServiceDeskProjectManager;
    private final VpOriginCustomFieldService vpOriginCustomFieldService;
    private final ServiceDeskCustomerRequestService customerRequestService;
    private final FieldJsonBuilderAccessor fieldJsonBuilderAccessor;
    private final InternalPortalService internalPortalService;
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final SDCustomfieldBulkEditSecurityHelper securityHelper;

    @Autowired
    public VpOriginBackdoorImpl(VpOriginManager vpOriginManager, RequestTypeInternalServiceImpl requestTypeInternalServiceImpl, UserFactory userFactory, IssueManager issueManager, I18nHelper i18nHelper, ErrorResultHelper errorResultHelper, CustomFieldValuePersister customFieldValuePersister, GenericConfigManager genericConfigManager, VpOriginCustomFieldService vpOriginCustomFieldService, InternalServiceDeskProjectManager internalServiceDeskProjectManager, ServiceDeskCustomerRequestService customerRequestService, FieldJsonBuilderAccessor fieldJsonBuilderAccessor, InternalPortalService internalPortalService, SoyTemplateRenderer soyTemplateRenderer, SDCustomfieldBulkEditSecurityHelper securityHelper) {
        this.vpOriginManager = vpOriginManager;
        this.requestTypeInternalServiceImpl = requestTypeInternalServiceImpl;
        this.userFactory = userFactory;
        this.issueManager = issueManager;
        this.i18nHelper = i18nHelper;
        this.errorResultHelper = errorResultHelper;
        this.customFieldValuePersister = customFieldValuePersister;
        this.genericConfigManager = genericConfigManager;
        this.internalServiceDeskProjectManager = internalServiceDeskProjectManager;
        this.vpOriginCustomFieldService = vpOriginCustomFieldService;
        this.customerRequestService = customerRequestService;
        this.fieldJsonBuilderAccessor = fieldJsonBuilderAccessor;
        this.internalPortalService = internalPortalService;
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.securityHelper = securityHelper;
    }

    public Option<String> canBulkChangeRequestType(List<Long> issueIds, Integer requestTypeId) {
        BulkEditBeanImpl bulkEditBean = new BulkEditBeanImpl(this.issueManager);
        List issueList = issueIds.stream().map(arg_0 -> ((IssueManager)this.issueManager).getIssueObject(arg_0)).collect(Collectors.toList());
        bulkEditBean.initSelectedIssues(issueList);
        VpOriginCFType vpOriginCFType = new VpOriginCFType(this.customFieldValuePersister, this.genericConfigManager, this.vpOriginManager, this.requestTypeInternalServiceImpl, this.requestTypeInternalServiceImpl, this.userFactory, this.i18nHelper, this.errorResultHelper, this.customerRequestService, this.fieldJsonBuilderAccessor, this.internalPortalService, this.internalServiceDeskProjectManager, this.soyTemplateRenderer, this.securityHelper);
        String errorMessage = vpOriginCFType.availableForBulkEdit((BulkEditBean)bulkEditBean);
        if (StringUtils.isEmpty((String)errorMessage)) {
            return Option.none();
        }
        return Option.some((Object)errorMessage);
    }

    public long getVpOriginCustomFieldId() {
        return this.vpOriginCustomFieldService.getVpOriginCustomField().getIdAsLong();
    }

    public List<Integer> searchSuggestions(Set<Integer> portalIds, String searchTerm, int maxNumResults) {
        return this.requestTypeInternalServiceImpl.searchRequestTypes(portalIds, (CheckedUser)this.userFactory.getCheckedUser().getOrNull(), searchTerm, maxNumResults).stream().map(RequestType::getId).collect(Collectors.toList());
    }
}

