/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.visiblefortesting;

import com.atlassian.annotations.Internal;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.bc.project.ProjectCreationData;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.bc.user.UserService;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeManager;
import com.atlassian.jira.issue.fields.screen.issuetype.ProjectIssueTypeScreenSchemeHelper;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserDetails;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.ErrorMessage;
import com.atlassian.pocketknife.api.commons.error.HttpStatusCode;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.requesttype.RequestTypeInternalService;
import com.atlassian.servicedesk.internal.api.visiblefortesting.TestDataSetupBackdoor;
import com.atlassian.servicedesk.internal.api.visiblefortesting.response.IssueTypeResponse;
import com.atlassian.servicedesk.internal.api.visiblefortesting.response.ProjectResponse;
import com.atlassian.servicedesk.internal.api.visiblefortesting.response.RequestTypeResponse;
import com.atlassian.servicedesk.internal.api.visiblefortesting.response.ScreenResponse;
import com.atlassian.servicedesk.internal.feature.customer.portal.PortalInternalManager;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.RequestTypeInternalManager;
import com.atlassian.servicedesk.internal.feature.servicedesk.ServiceDeskInternalManager;
import com.atlassian.servicedesk.internal.feature.usermanagement.AgentManager;
import com.atlassian.servicedesk.internal.user.permission.roles.ServiceDeskJiraRoleManager;
import com.atlassian.servicedesk.internal.user.permission.roles.ServiceDeskProjectRole;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
@Internal
public class TestDataSetupBackdoorImpl
implements TestDataSetupBackdoor {
    private static final Logger log = LoggerFactory.getLogger(TestDataSetupBackdoorImpl.class);
    private static final String ADMIN = "admin";
    private static final String JIRA_ADMINISTRATORS_GROUP_NAME = "jira-administrators";
    private static final String CLASSIC_SD_PROJECT_TEMPLATE_KEY = "com.atlassian.servicedesk:classic-service-desk-project";
    private static final String ITIL_SD_PROJECT_TEMPLATE_KEY = "com.atlassian.servicedesk:itil-service-desk-project";
    private static final String ITIL_V2_SD_PROJECT_TEMPLATE_KEY = "com.atlassian.servicedesk:itil-v2-service-desk-project";
    private static final String CUSTOMER_SD_PROJECT_TEMPLATE_KEY = "com.atlassian.servicedesk:customer-service-desk-project";
    private static final String BASIC_SD_PROJECT_TEMPLATE_KEY = "com.atlassian.servicedesk:basic-service-desk-project";
    @Autowired
    private UserFactory userFactory;
    @Autowired
    private RequestTypeInternalManager requestTypeInternalManager;
    @Autowired
    private RequestTypeInternalService requestTypeInternalService;
    @Autowired
    private PortalInternalManager portalManager;
    @Autowired
    private UserManager userManager;
    @Autowired
    private AgentManager agentManager;
    @Autowired
    private ServiceDeskJiraRoleManager serviceDeskJIRARoleManager;
    @Autowired
    private UserUtil userUtil;
    @Autowired
    private ProjectManager projectManager;
    @Autowired
    private ServiceDeskInternalManager serviceDeskInternalManager;
    @Autowired
    private UserService userService;
    @Autowired
    private ProjectService projectService;
    @Autowired
    private GroupManager groupManager;
    @Autowired
    private ProjectIssueTypeScreenSchemeHelper issueTypeScreenSchemeHelper;
    @Autowired
    private FieldScreenManager fieldScreenManager;
    @Autowired
    private FieldScreenSchemeManager fieldScreenSchemeManager;
    @Autowired
    private PermissionSchemeManager permissionSchemeManager;

    public ServiceDesk createClassicServiceDeskProject(String projectLeadUserName, String projectKey, String projectName) {
        return this.createServiceDeskProject(projectLeadUserName, projectKey, projectName, CLASSIC_SD_PROJECT_TEMPLATE_KEY);
    }

    public ServiceDesk createBasicServiceDeskProject(String projectLeadUserName, String projectKey, String projectName) {
        return this.createServiceDeskProject(projectLeadUserName, projectKey, projectName, BASIC_SD_PROJECT_TEMPLATE_KEY);
    }

    public ServiceDesk createITILServiceDeskProject(String projectLeadUserName, String projectKey, String projectName) {
        return this.createServiceDeskProject(projectLeadUserName, projectKey, projectName, ITIL_SD_PROJECT_TEMPLATE_KEY);
    }

    public ServiceDesk createITILV2ServiceDeskProject(String projectLeadUserName, String projectKey, String projectName) {
        return this.createServiceDeskProject(projectLeadUserName, projectKey, projectName, ITIL_V2_SD_PROJECT_TEMPLATE_KEY);
    }

    public ServiceDesk createCustomerServiceDeskProject(String projectLeadUserName, String projectKey, String projectName) {
        return this.createServiceDeskProject(projectLeadUserName, projectKey, projectName, CUSTOMER_SD_PROJECT_TEMPLATE_KEY);
    }

    private ServiceDesk createServiceDeskProject(String projectLeadUserName, String projectKey, String projectName, String projectTemplate) {
        ApplicationUser projectLeadUser = this.userManager.getUserByKey(projectLeadUserName);
        if (Objects.isNull(projectLeadUser)) {
            throw new IllegalArgumentException("Cannot create project because of invalid Project Lead username:" + projectLeadUserName);
        }
        Project project = this.createProjectWithTemplate(projectLeadUser, projectKey, projectName, projectTemplate);
        return (ServiceDesk)this.serviceDeskInternalManager.getServiceDesk(project, false).right().get();
    }

    private Project createProjectWithTemplate(ApplicationUser lead, String projectKey, String projectName, String projectTemplate) {
        ProjectCreationData projectCreationData = new ProjectCreationData.Builder().withName(projectName).withKey(projectKey).withLead(lead).withProjectTemplateKey(projectTemplate).build();
        ApplicationUser admin = this.userManager.getUserByName(ADMIN);
        if (Objects.isNull(admin)) {
            throw new RuntimeException("Cannot find admin user, you have to create JIRA Admin with user name 'admin'.");
        }
        ProjectService.CreateProjectValidationResult createProjectValidationResult = this.projectService.validateCreateProject(admin, projectCreationData);
        if (createProjectValidationResult.isValid()) {
            return this.projectService.createProject(createProjectValidationResult);
        }
        Collection errorMessages2 = createProjectValidationResult.getErrorCollection().getErrorMessages();
        Map errors = createProjectValidationResult.getErrorCollection().getErrors();
        StringBuilder sb = new StringBuilder();
        sb.append("Failed to create template with template: " + projectCreationData.getProjectTemplateKey().getKey() + " and type: " + projectCreationData.getProjectTypeKey());
        if (!errorMessages2.isEmpty()) {
            sb.append("Error Messages:").append("\n");
            errorMessages2.forEach(msg -> sb.append("\t").append((String)msg).append("\n"));
        }
        if (!errors.isEmpty()) {
            sb.append("Errors:").append("\n");
            errors.forEach((key, value) -> sb.append("\t").append((String)key).append(": ").append((String)value).append("\n"));
        }
        throw new RuntimeException("Failed to create project:\n" + sb.toString());
    }

    public void addUserToGroups(String username, Set<String> groups) {
        ApplicationUser user = this.userManager.getUserByName(username);
        if (user == null) {
            log.error("User {} does not exist, so can not add to groups", (Object)username);
            return;
        }
        if (CollectionUtils.isNotEmpty(groups)) {
            groups.forEach(g -> {
                Option groupOption = Option.option((Object)this.groupManager.getGroup(g));
                if (groupOption.isEmpty()) {
                    log.error("Group {} does not exist, can not add user {} to it", g, (Object)user.getName());
                    return;
                }
                try {
                    this.groupManager.addUserToGroup(user, (Group)groupOption.get());
                }
                catch (Exception e) {
                    throw new RuntimeException(String.format("Cannot add user:\"%s\" to group:\"%s\"", user.getName(), g), e);
                }
            });
        }
    }

    public ProjectResponse buildServiceDeskProjectResponse(long projectId) {
        Project project = this.projectManager.getProjectObj(Long.valueOf(projectId));
        Portal portal = (Portal)this.portalManager.getPortalByProjectId(projectId).right().get();
        ServiceDesk serviceDesk = (ServiceDesk)this.serviceDeskInternalManager.getServiceDesk(project, false).right().get();
        List<RequestType> allRequestTypes = this.requestTypeInternalManager.getAllRequestTypes(portal);
        List requestTypeResponses = allRequestTypes.stream().map(this::buildRequestTypeResponse).collect(Collectors.toList());
        List issueTypeResponses = project.getIssueTypes().stream().map(this::buildIssueTypeResponse).collect(Collectors.toList());
        List<ScreenResponse> screenResponses = this.getScreensForProject(project);
        Scheme permissionScheme = this.permissionSchemeManager.getSchemeFor(project);
        return ProjectResponse.builder().projectName(project.getName()).projectKey(project.getKey()).projectId(project.getId()).portalId(Long.valueOf(portal.getId())).portalKey(this.portalManager.toPortalInternal(portal).getKey()).servicedeskId((long)serviceDesk.getId()).screenResponses(screenResponses).requestTypeResponses(requestTypeResponses).issueTypeResponses(issueTypeResponses).permissionSchemeId(permissionScheme.getId()).build();
    }

    private IssueTypeResponse buildIssueTypeResponse(IssueType issueType) {
        return new IssueTypeResponse(issueType.getId(), issueType.getName());
    }

    private RequestTypeResponse buildRequestTypeResponse(RequestType requestType) {
        return new RequestTypeResponse(requestType.getName(), this.requestTypeInternalService.toRequestTypeInternal(requestType).getKey(), (long)requestType.getId());
    }

    private List<ScreenResponse> getScreensForProject(Project project) {
        return this.fieldScreenManager.getFieldScreens().stream().filter(screen -> this.isProjectUsingFieldScreen((FieldScreen)screen, project)).map(screen -> new ScreenResponse(screen.getId().longValue(), screen.getName())).collect(Collectors.toList());
    }

    public void createUser(String username, String displayName, String email, String password) {
        ApplicationUser oldUser = this.userManager.getUserByName(username);
        if (oldUser != null) {
            this.updateOldUser(username, displayName, email, password, oldUser);
        } else {
            try {
                this.userManager.createUser(new UserDetails(username, displayName).withEmail(email).withPassword(password));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void updateOldUser(String username, String displayName, String email, String password, ApplicationUser oldUser) {
        String newDisplayName = StringUtils.defaultIfEmpty((String)displayName, (String)oldUser.getDisplayName());
        String newEmail = StringUtils.defaultIfEmpty((String)email, (String)oldUser.getEmailAddress());
        if (StringUtils.isNotEmpty((String)password)) {
            try {
                this.userUtil.changePassword(oldUser, password);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (!Objects.equals(newDisplayName, oldUser.getDisplayName()) || !Objects.equals(newEmail, oldUser.getEmailAddress())) {
            ApplicationUser newUser = this.userService.newUserBuilder(oldUser).active(true).name(username).displayName(newDisplayName).emailAddress(newEmail).build();
            UserService.UpdateUserValidationResult updateUserValidationResult = this.userService.validateUpdateUser(newUser);
            if (!updateUserValidationResult.isValid()) {
                throw new RuntimeException("Failed to create user:" + Arrays.toString(updateUserValidationResult.getErrorCollection().getErrorMessages().toArray()));
            }
            this.userService.updateUser(updateUserValidationResult);
        }
    }

    public void promoteUserToRole(String username, String projectKey, TestDataSetupBackdoor.UserRole role) {
        CheckedUser checkedUser = (CheckedUser)this.userFactory.wrap(this.userManager.getUserByName(username)).right().getOrThrow(() -> new RuntimeException(String.format("Cannot promote user %s to %s Role", username, role.toString())));
        Project project = this.projectManager.getProjectObjByKey(projectKey);
        Either userPromoteResult = Either.right((Object)checkedUser);
        switch (role) {
            case AGENT: {
                this.agentManager.promoteUserToAgent(checkedUser);
                userPromoteResult = this.serviceDeskJIRARoleManager.addUserToRole(checkedUser, project, ServiceDeskProjectRole.TEAM);
                break;
            }
            case CUSTOMER: {
                userPromoteResult = this.serviceDeskJIRARoleManager.addUserToRole(checkedUser, project, ServiceDeskProjectRole.CUSTOMER);
                break;
            }
            case ADMIN: {
                userPromoteResult = this.serviceDeskJIRARoleManager.addUserToRole(checkedUser, project, ServiceDeskProjectRole.ADMIN);
                break;
            }
            case JIRA_ADMIN: {
                try {
                    this.addUserToGroups(checkedUser.getName(), Collections.singleton(JIRA_ADMINISTRATORS_GROUP_NAME));
                    userPromoteResult = Either.right((Object)checkedUser);
                    break;
                }
                catch (Exception e) {
                    userPromoteResult = Either.left((Object)new AnError(ErrorMessage.builder().message(e.getMessage()).build(), HttpStatusCode.BAD_REQUEST));
                }
            }
        }
        if (userPromoteResult.isLeft()) {
            throw new RuntimeException(String.format("Failed to promote user \"%s\" to role \"%s\". \n Reasons:%s", username, role, ((AnError)userPromoteResult.left().get()).getMessage().getMessage()));
        }
    }

    public void promoteUserToAgent(String username) {
        CheckedUser checkedUser = (CheckedUser)this.userFactory.wrap(this.userManager.getUserByName(username)).right().getOrThrow(() -> new RuntimeException(String.format("Cannot promote user %s to Agent", username)));
        this.agentManager.promoteUserToAgent(checkedUser);
    }

    public void cleanUpData() {
        ApplicationUser admin = this.userManager.getUserByKey(ADMIN);
        this.cleanupProjects(admin);
        this.cleanupUsers(admin);
    }

    private void cleanupUsers(ApplicationUser admin) {
        this.userManager.getAllApplicationUsers().stream().filter(applicationUser -> !Objects.equals(applicationUser.getUsername(), ADMIN)).forEach(userToDelete -> this.userUtil.removeUser(admin, userToDelete));
    }

    private void cleanupProjects(ApplicationUser admin) {
        this.projectManager.getProjects().forEach(p -> {
            ProjectService.DeleteProjectValidationResult deleteProjectValidationResult = this.projectService.validateDeleteProject(admin, p.getKey());
            this.projectService.deleteProject(admin, deleteProjectValidationResult);
        });
    }

    private boolean isProjectUsingFieldScreen(FieldScreen fieldScreen, Project project) {
        HashSet fieldScreenSchemes = Sets.newHashSet((Iterable)this.fieldScreenSchemeManager.getFieldScreenSchemes(fieldScreen));
        Collection projects = this.issueTypeScreenSchemeHelper.getProjectsForFieldScreenSchemes((Set)fieldScreenSchemes).values();
        return projects.contains(project);
    }
}

