/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.visiblefortesting;

import com.atlassian.annotations.Internal;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.persistence.GlobalPropertyDao;
import com.atlassian.servicedesk.internal.admin.EmailRequestsSettingsManager;
import com.atlassian.servicedesk.internal.api.visiblefortesting.ServiceDeskGlobalPropertiesBackdoor;
import com.atlassian.servicedesk.internal.feature.queue.QueueServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
@Internal
public class ServiceDeskGlobalPropertiesBackdoorImpl
implements ServiceDeskGlobalPropertiesBackdoor {
    private final GlobalPropertyDao globalPropertyDao;
    private final EmailRequestsSettingsManager emailRequestsSettingsManager;

    @Autowired
    public ServiceDeskGlobalPropertiesBackdoorImpl(GlobalPropertyDao globalPropertyDao, EmailRequestsSettingsManager emailRequestsSettingsManager) {
        this.globalPropertyDao = globalPropertyDao;
        this.emailRequestsSettingsManager = emailRequestsSettingsManager;
    }

    public Long getCustomerPerPage() {
        return this.globalPropertyDao.getLongProperty("com.atlassian.servicedesk:customers_page_pagination_preferred_fetch_block_size");
    }

    public void setCustomerPerPage(Long value) {
        this.globalPropertyDao.setLongProperty("com.atlassian.servicedesk:customers_page_pagination_preferred_fetch_block_size", value);
    }

    public void resetCustomerPerPage() {
        this.globalPropertyDao.setLongProperty("com.atlassian.servicedesk:customers_page_pagination_preferred_fetch_block_size", Long.valueOf(50L));
    }

    public Long getCustomerMaximumPageRange() {
        return this.globalPropertyDao.getLongProperty("com.atlassian.servicedesk:customers_page_pagination_preferred_pages_range");
    }

    public void setCustomerMaximumPageRange(Long value) {
        this.globalPropertyDao.setLongProperty("com.atlassian.servicedesk:customers_page_pagination_preferred_pages_range", value);
    }

    public void resetCustomerMaximumPageRange() {
        this.globalPropertyDao.setLongProperty("com.atlassian.servicedesk:customers_page_pagination_preferred_pages_range", Long.valueOf(5L));
    }

    public Long getAgentPerPage() {
        return this.globalPropertyDao.getLongProperty("com.atlassian.servicedesk:workload_page_pagination_preferred_fetch_block_size");
    }

    public void setAgentPerPage(Long value) {
        this.globalPropertyDao.setLongProperty("com.atlassian.servicedesk:workload_page_pagination_preferred_fetch_block_size", value);
    }

    public void resetAgentPerPage() {
        this.globalPropertyDao.setLongProperty("com.atlassian.servicedesk:workload_page_pagination_preferred_fetch_block_size", Long.valueOf(50L));
    }

    public Long getAgentMaximumPageRange() {
        return this.globalPropertyDao.getLongProperty("com.atlassian.servicedesk:workload_page_pagination_preferred_pages_range");
    }

    public void setAgentMaximumPageRange(Long value) {
        this.globalPropertyDao.setLongProperty("com.atlassian.servicedesk:workload_page_pagination_preferred_pages_range", value);
    }

    public void resetAgentMaximumPageRange() {
        this.globalPropertyDao.setLongProperty("com.atlassian.servicedesk:workload_page_pagination_preferred_pages_range", Long.valueOf(5L));
    }

    public boolean getOutsiderCommentsEnabled() {
        return this.emailRequestsSettingsManager.getOutsiderCommentsEnabled();
    }

    public void resetOutsiderCommentsEnabled() {
        this.emailRequestsSettingsManager.setOutsiderCommentsEnabled(true);
    }

    public boolean getEmailRequestsFormattingEnabled() {
        return this.emailRequestsSettingsManager.getFormattingEnabled();
    }

    public void resetEmailRequestsFormattingEnabled() {
        this.emailRequestsSettingsManager.setFormattingEnabled(true);
    }

    public String getEmailRequestsTrimmingMode() {
        return this.emailRequestsSettingsManager.getTrimmingMode().name();
    }

    public void resetEmailRequestsTrimmingMode() {
        this.emailRequestsSettingsManager.setTrimmingMode(EmailRequestsSettingsManager.DEFAULT_TRIMMING_MODE);
    }

    public String getEmailRequestCreateCustomerMode() {
        return this.emailRequestsSettingsManager.getEmailCreateCustomerMode().name();
    }

    public void resetEmailRequestCreateCustomerMode() {
        this.emailRequestsSettingsManager.setEmailCreateCustomerMode(EmailRequestsSettingsManager.DEFAULT_CREATE_CUSTOMER_MODE);
    }

    public Long getQueueCountCacheExpiryMillis() {
        return this.globalPropertyDao.getLongProperty("sd.query.service.cache.expiry.timeout.millis");
    }

    public void setQueueCountCacheExpiryMillis(Long value) {
        this.globalPropertyDao.setLongProperty("sd.query.service.cache.expiry.timeout.millis", value);
    }

    public void reetQueueCountCacheExpiryMillis() {
        this.globalPropertyDao.setLongProperty("sd.query.service.cache.expiry.timeout.millis", Long.valueOf(QueueServiceImpl.EXPIRY_MILLIS_DEFAULT));
    }
}

