/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.visiblefortesting;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.internal.api.ServiceDeskManager;
import com.atlassian.servicedesk.internal.api.report.ReportService;
import com.atlassian.servicedesk.internal.api.visiblefortesting.ReportBackdoor;
import com.atlassian.servicedesk.internal.api.visiblefortesting.response.ReportBackdoorModel;
import io.atlassian.fugue.Either;
import java.util.Collection;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
@Internal
public class ReportBackdoorImpl
implements ReportBackdoor {
    @Autowired
    ReportService reportService;
    @Autowired
    ServiceDeskManager serviceDeskManager;

    public Either<AnError, Collection<ReportBackdoorModel>> getServiceDeskReports(ApplicationUser applicationUser, int serviceDeskId) {
        Either serviceDesk = this.serviceDeskManager.getServiceDeskById(serviceDeskId);
        return serviceDesk.flatMap(sd -> this.reportService.getReports(applicationUser, sd)).map(reports -> reports.stream().map(ReportBackdoorModel::fromReport).collect(Collectors.toList()));
    }
}

