/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.visiblefortesting;

import com.atlassian.annotations.Internal;
import com.atlassian.fugue.Either;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.queue.QueueQuery;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.api.queues.InternalQueueService;
import com.atlassian.servicedesk.internal.api.visiblefortesting.QueueCacheBackdoor;
import io.atlassian.fugue.Option;
import java.util.Optional;
import java.util.function.Function;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
@Internal
public class QueueCacheBackdoorImpl
implements QueueCacheBackdoor {
    private final InternalQueueService internalQueueService;

    @Autowired
    public QueueCacheBackdoorImpl(InternalQueueService internalQueueService) {
        this.internalQueueService = internalQueueService;
    }

    public Option<Long> getQueueCount(CheckedUser checkedUser, long queueId, long serviceDeskId) {
        return this.runGetQueueCount(checkedUser, queueId, serviceDeskId, false);
    }

    public Option<Long> getCacheQueueCount(CheckedUser checkedUser, long queueId, long serviceDeskId) {
        return this.runGetQueueCount(checkedUser, queueId, serviceDeskId, true);
    }

    private Option<Long> runGetQueueCount(CheckedUser checkedUser, long queueId, long serviceDeskId, boolean cache) {
        QueueQuery queueQuery = this.internalQueueService.newQueueQueryBuilder().queueId(queueId).includeIssueCount(true).serviceDeskId(serviceDeskId).build();
        io.atlassian.fugue.Either queuesWithCachedCount = cache ? this.internalQueueService.getQueuesWithCachedCount(checkedUser.forJIRA(), queueQuery) : StepsConverters.newerEither((Either)this.internalQueueService.getQueues(checkedUser.forJIRA(), queueQuery));
        return queuesWithCachedCount.toOption().flatMap(queues -> Option.fromOptional((Optional)queues.findFirst())).map(queue -> (Long)Option.fromOptional((Optional)queue.getIssueCount()).fold(() -> 0L, Function.identity()));
    }
}

