/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.visiblefortesting;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.servicedesk.api.organization.CustomerOrganization;
import com.atlassian.servicedesk.internal.api.visiblefortesting.OrganizationSetupBackdoor;
import com.atlassian.servicedesk.internal.api.visiblefortesting.response.OrganizationSetupDataResponse;
import com.atlassian.servicedesk.internal.customfields.organization.CustomerOrganizationsCFManager;
import com.atlassian.servicedesk.internal.feature.organization.CustomerOrganizationManager;
import com.atlassian.servicedesk.internal.feature.organization.dao.CustomerOrganizationMemberQStore;
import com.atlassian.servicedesk.internal.feature.organization.dao.CustomerOrganizationProjectQStore;
import com.atlassian.servicedesk.internal.feature.organization.dao.CustomerOrganizationQStore;
import com.atlassian.servicedesk.internal.feature.organization.dao.exceptions.IllegalOrganizationNameException;
import com.atlassian.servicedesk.internal.feature.organization.dao.exceptions.OrganizationNotFoundException;
import com.atlassian.servicedesk.internal.feature.organization.util.CustomerOrganizationUtil;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
@Internal
public class OrganizationSetupBackdoorImpl
implements OrganizationSetupBackdoor {
    private static final Logger logger = LoggerFactory.getLogger(OrganizationSetupBackdoorImpl.class);
    private final CustomerOrganizationQStore customerOrganizationQStore;
    private final CustomerOrganizationMemberQStore memberQStore;
    private final CustomerOrganizationProjectQStore projectQStore;
    private final UserManager userManager;
    private final DatabaseAccessor databaseAccessor;
    private final CustomerOrganizationsCFManager organizationsCFManager;
    private final CustomerOrganizationManager customerOrganizationManager;

    @Autowired
    public OrganizationSetupBackdoorImpl(CustomerOrganizationQStore customerOrganizationQStore, CustomerOrganizationMemberQStore memberQStore, CustomerOrganizationProjectQStore projectQStore, UserManager userManager, DatabaseAccessor databaseAccessor, CustomerOrganizationsCFManager organizationsCFManager, CustomerOrganizationManager customerOrganizationManager) {
        this.customerOrganizationQStore = customerOrganizationQStore;
        this.memberQStore = memberQStore;
        this.projectQStore = projectQStore;
        this.userManager = userManager;
        this.databaseAccessor = databaseAccessor;
        this.organizationsCFManager = organizationsCFManager;
        this.customerOrganizationManager = customerOrganizationManager;
    }

    public Option<OrganizationSetupDataResponse> setupData(String name, Set<String> userKeys, Set<String> userNames, Option<Long> projectId) {
        Objects.requireNonNull(name, "name");
        try {
            CustomerOrganization organization = (CustomerOrganization)this.databaseAccessor.runInTransaction(databaseConnection -> {
                CustomerOrganization org = this.customerOrganizationQStore.getOrCreate(name, (DatabaseConnection)databaseConnection);
                HashSet<String> addedUserKeys = new HashSet<String>(userKeys);
                if (!userNames.isEmpty()) {
                    Set<String> userKeyFromNames = this.getUserKeysFromUsernames(userNames);
                    addedUserKeys.addAll(userKeyFromNames);
                }
                if (!addedUserKeys.isEmpty()) {
                    this.memberQStore.addOrganizationMembers(org.getId(), (Set<String>)addedUserKeys, (DatabaseConnection)databaseConnection);
                }
                if (projectId.isDefined()) {
                    this.projectQStore.addOrganizationsToProject(Sets.newHashSet((Object[])new Integer[]{org.getId()}), (Long)projectId.get(), (DatabaseConnection)databaseConnection);
                }
                return org;
            });
            return Option.some((Object)new OrganizationSetupDataResponse(organization.getName(), organization.getId()));
        }
        catch (IllegalOrganizationNameException ex) {
            logger.error("Organization name= " + ex.getIllegalName() + " is too long", (Throwable)ex);
            return Option.none();
        }
        catch (OrganizationNotFoundException ex) {
            logger.error("The following orgIds= " + ex.getOrganizationIds() + " could not be found", (Throwable)ex);
            return Option.none();
        }
        catch (Exception ex) {
            logger.error("Failed to setup data", (Throwable)ex);
            return Option.none();
        }
    }

    private Set<String> getUserKeysFromUsernames(Set<String> userNames) {
        return userNames.stream().map(arg_0 -> ((UserManager)this.userManager).getUserByName(arg_0)).filter(user -> user != null).map(ApplicationUser::getKey).collect(Collectors.toSet());
    }

    public Set<Integer> cleanupAllOrganizations() {
        try {
            Set<Integer> orgIds = CustomerOrganizationUtil.transformToIds(this.customerOrganizationManager.getAllOrganizations());
            orgIds.forEach(this.customerOrganizationManager::deleteOrganization);
            return orgIds;
        }
        catch (Exception ex) {
            logger.error("Failed to cleanup all organizations", (Throwable)ex);
            return Collections.emptySet();
        }
    }

    public Set<Integer> cleanupOrganization(Set<Integer> orgIds) {
        Objects.requireNonNull(orgIds, "orgIds");
        try {
            orgIds.forEach(this.customerOrganizationManager::deleteOrganization);
            return orgIds;
        }
        catch (Exception ex) {
            logger.error("Failed to cleanup organization", (Throwable)ex);
            return Collections.emptySet();
        }
    }

    public Set<Integer> cleanupOrganizationByName(Set<String> orgNames) {
        Objects.requireNonNull(orgNames, "orgNames");
        Set<Integer> orgIds = this.customerOrganizationQStore.getByNames(orgNames).stream().map(CustomerOrganization::getId).collect(Collectors.toSet());
        return this.cleanupOrganization(orgIds);
    }

    public Set<Integer> cleanupOrganizationByUsername(Set<String> username) {
        Set<String> userKeyFromNames = this.getUserKeysFromUsernames(username);
        Set<Integer> orgIdsToDelete = userKeyFromNames.stream().map(userKey -> this.memberQStore.getOrganizationsForUser((String)userKey).stream().map(CustomerOrganization::getId).collect(Collectors.toSet())).flatMap(Collection::stream).collect(Collectors.toSet());
        return this.cleanupOrganization(orgIdsToDelete);
    }

    public String getCustomFieldId() {
        return ((CustomField)this.organizationsCFManager.getOrCreateOrganizationsCF().get()).getId();
    }
}

