/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.visiblefortesting;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.internal.api.onboarding.OnBoardingPropertiesService;
import com.atlassian.servicedesk.internal.api.visiblefortesting.OnboardingPropertiesServiceBackdoor;
import com.atlassian.servicedesk.internal.feature.servicedesk.ServiceDeskInternalManager;
import io.atlassian.fugue.Either;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
@Internal
public class OnboardingPropertiesServiceBackdoorImpl
implements OnboardingPropertiesServiceBackdoor {
    private final OnBoardingPropertiesService onBoardingPropertiesService;
    private final ServiceDeskInternalManager serviceDeskInternalManager;
    private final ProjectManager projectManager;

    @Autowired
    public OnboardingPropertiesServiceBackdoorImpl(OnBoardingPropertiesService onBoardingPropertiesService, ServiceDeskInternalManager serviceDeskInternalManager, ProjectManager projectManager) {
        this.onBoardingPropertiesService = onBoardingPropertiesService;
        this.serviceDeskInternalManager = serviceDeskInternalManager;
        this.projectManager = projectManager;
    }

    public void setAllOnboardingPropertiesForUser(ApplicationUser user, String projectKey) {
        Project project = this.projectManager.getProjectByCurrentKey(projectKey);
        if (project == null) {
            return;
        }
        Either<AnError, ServiceDesk> serviceDeskOpt = this.serviceDeskInternalManager.getServiceDesk(project, false);
        if (serviceDeskOpt.isLeft()) {
            return;
        }
        ServiceDesk serviceDesk = (ServiceDesk)serviceDeskOpt.getOrNull();
        this.onBoardingPropertiesService.dismissAdminAgentHelpBubble("local.servicedesk.help.bubble.queues.page.shown", user, serviceDesk);
        this.onBoardingPropertiesService.dismissAdminAgentHelpBubble("local.servicedesk.help.bubble.custom.reports.page.shown", user, serviceDesk);
        this.onBoardingPropertiesService.dismissAdminAgentHelpBubble("local.servicedesk.help.bubble.customers.page.shown", user, serviceDesk);
        this.onBoardingPropertiesService.dismissAdminAgentHelpBubble("local.servicedesk.help.bubble.email.settings.admin.page.shown", user, serviceDesk);
    }
}

