/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.visiblefortesting;

import com.atlassian.annotations.Internal;
import com.atlassian.fugue.Either;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.customer.CustomerContextService;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.user.permission.ServiceDeskLicenseAndPermissionService;
import com.atlassian.servicedesk.internal.api.visiblefortesting.IssuePermissionBackdoor;
import com.atlassian.servicedesk.internal.feature.jira.issue.IssueHelper;
import io.atlassian.fugue.Suppliers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
@Internal
public class IssuePermissionBackdoorImpl
implements IssuePermissionBackdoor {
    private final UserFactory userFactory;
    private final IssueHelper issueHelper;
    private final CustomerContextService customerContextService;
    private final ServiceDeskLicenseAndPermissionService serviceDeskLicenseAndPermissionService;

    @Autowired
    public IssuePermissionBackdoorImpl(UserFactory userFactory, IssueHelper issueHelper, CustomerContextService customerContextService, ServiceDeskLicenseAndPermissionService serviceDeskLicenseAndPermissionService) {
        this.userFactory = userFactory;
        this.issueHelper = issueHelper;
        this.customerContextService = customerContextService;
        this.serviceDeskLicenseAndPermissionService = serviceDeskLicenseAndPermissionService;
    }

    public boolean canViewIssueInAgentView(String username, String issueKey) {
        return (Boolean)this.customerContextService.runOutOfCustomerContext(() -> this.getIssue(username, issueKey));
    }

    public boolean canViewIssueInCustomerView(String username, String issueKey) {
        return (Boolean)this.customerContextService.runInCustomerContext(() -> this.getIssue(username, issueKey));
    }

    private boolean getIssue(String username, String issueKey) {
        return (Boolean)Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.wrapUsername(username))).then(user -> this.issueHelper.getIssueByKey((CheckedUser)user, issueKey)).yield((arg_0, arg_1) -> ((ServiceDeskLicenseAndPermissionService)this.serviceDeskLicenseAndPermissionService).canViewIssue(arg_0, arg_1)).getOr(Suppliers.alwaysFalse());
    }
}

