/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.utils.context;

import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.servicedesk.api.customer.NoExceptionsCallable;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.bootstrap.lifecycle.ServiceDeskComponentAccessor;
import com.atlassian.servicedesk.internal.featureflag.SDFeatureFlags;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
@Component
public class ServiceDeskOutsideCustomerPermissionContext {
    private static final ThreadLocal<Set<OutsideCustomerIssuePermissionContext>> CONTEXT = ThreadLocal.withInitial(ImmutableSet::of);
    private static final Logger log = LoggerFactory.getLogger(ServiceDeskOutsideCustomerPermissionContext.class);
    private final FeatureManager featureManager;

    @Autowired
    public ServiceDeskOutsideCustomerPermissionContext(FeatureManager featureManager) {
        this.featureManager = featureManager;
    }

    public <T> T inOutsideCustomerContext(CheckedUser checkedUser, Issue issue, NoExceptionsCallable<T> callable) {
        return this.inOutsideCustomerContext((Set<OutsideCustomerIssuePermissionContext>)ImmutableSet.of((Object)new OutsideCustomerIssuePermissionContext(checkedUser, issue)), callable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T inOutsideCustomerContext(Set<OutsideCustomerIssuePermissionContext> outsideCustomerIssuePermissionContexts, NoExceptionsCallable<T> callable) {
        if (!this.featureManager.isEnabled(SDFeatureFlags.OUTSIDER_COMMENTS)) {
            return (T)callable.call();
        }
        Set<OutsideCustomerIssuePermissionContext> currentContextValue = this.getOutsideCustomerContext();
        if (currentContextValue.containsAll(outsideCustomerIssuePermissionContexts)) {
            return (T)callable.call();
        }
        CONTEXT.remove();
        try {
            Set<OutsideCustomerIssuePermissionContext> onlyOutsidersToAddIntoContext = this.getOnlyActualOutsiders(outsideCustomerIssuePermissionContexts);
            CONTEXT.set((Set<OutsideCustomerIssuePermissionContext>)ImmutableSet.builder().addAll(currentContextValue).addAll(onlyOutsidersToAddIntoContext).build());
            Object object = callable.call();
            return (T)object;
        }
        finally {
            if (CollectionUtils.isEmpty(currentContextValue)) {
                CONTEXT.remove();
            } else {
                CONTEXT.set(currentContextValue);
            }
        }
    }

    public Set<OutsideCustomerIssuePermissionContext> getOutsideCustomerContext() {
        ImmutableSet contexts = ImmutableSet.copyOf((Collection)CONTEXT.get());
        if (CollectionUtils.isEmpty((Collection)contexts)) {
            CONTEXT.remove();
        }
        return contexts;
    }

    public boolean isInIssueOutsideCustomerContext(CheckedUser checkedUser, Issue issue) {
        return this.getOutsideCustomerContext().contains(new OutsideCustomerIssuePermissionContext(checkedUser, issue));
    }

    public boolean isInProjectOutsideCustomerContext(CheckedUser checkedUser, Project project) {
        return this.getOutsideCustomerContext().stream().anyMatch(context -> Objects.equals(context.getCheckedUser(), checkedUser) && Objects.equals(context.getIssue().getProjectObject(), project));
    }

    private Set<OutsideCustomerIssuePermissionContext> getOnlyActualOutsiders(Set<OutsideCustomerIssuePermissionContext> requestedContexts) {
        Set<OutsideCustomerIssuePermissionContext> onlyOutsiders = requestedContexts.stream().filter(outsideContext -> ServiceDeskComponentAccessor.getOutsiderPermissionChecker().isUserAnOutsider(outsideContext.getCheckedUser(), outsideContext.getIssue())).collect(Collectors.toSet());
        Sets.SetView difference = Sets.difference(requestedContexts, onlyOutsiders);
        if (!difference.isEmpty()) {
            log.warn("Ignoring request to add {} records into outsider customer context, as the user has failed the outsider permission check for specific issue : {}", (Object)difference.size(), (Object)difference);
            log.debug("Current call stack that is asking to add non outsider into the outsider context", (Throwable)new Exception());
        }
        return onlyOutsiders;
    }

    @ParametersAreNonnullByDefault
    @ReturnValuesAreNonnullByDefault
    public static final class OutsideCustomerIssuePermissionContext {
        private final CheckedUser checkedUser;
        private final Issue issue;

        public OutsideCustomerIssuePermissionContext(CheckedUser checkedUser, Issue issue) {
            this.checkedUser = (CheckedUser)Assertions.notNull((String)"checkedUser", (Object)checkedUser);
            this.issue = (Issue)Assertions.notNull((String)"issue", (Object)issue);
        }

        public Issue getIssue() {
            return this.issue;
        }

        public CheckedUser getCheckedUser() {
            return this.checkedUser;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OutsideCustomerIssuePermissionContext that = (OutsideCustomerIssuePermissionContext)o;
            return Objects.equals(this.checkedUser, that.checkedUser) && Objects.equals(this.issue, that.issue);
        }

        public int hashCode() {
            return Objects.hash(this.checkedUser, this.issue);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("checkedUser", (Object)this.checkedUser).add("issue", (Object)this.issue).toString();
        }
    }
}

