/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.utils.context;

import com.atlassian.jira.security.PermissionManager;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.servicedesk.api.customer.CustomerContextService;
import com.atlassian.servicedesk.api.customer.NoExceptionsCallable;
import com.atlassian.servicedesk.internal.utils.context.ReentrantThreadLocalBasedCodeContext;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class CustomerContextServiceImpl
extends ReentrantThreadLocalBasedCodeContext
implements CustomerContextService {
    private static final Logger log = Logger.getLogger(CustomerContextServiceImpl.class);
    private static ThreadLocal<Boolean> CONTEXT = CustomerContextServiceImpl.newThreadLocal();
    private final PermissionManager permissionManager;

    @Override
    ThreadLocal<Boolean> perClassStaticThreadLocal() {
        return CONTEXT;
    }

    @Autowired
    public CustomerContextServiceImpl(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public <T> T runInCustomerContext(NoExceptionsCallable<T> callable) {
        return this.runInContext(callable);
    }

    public void runInCustomerContext(Runnable runnable) {
        this.runInContext(runnable);
    }

    public <T> T inCustomerContext(Callable<T> callable) {
        return this.runInContext(() -> {
            try {
                return callable.call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void inCustomerContext(Runnable runnable) {
        this.runInContext(runnable);
    }

    public <T> T runOutOfCustomerContext(NoExceptionsCallable<T> callable) {
        return this.runOutOfContext(callable);
    }

    public void runOutOfCustomerContext(Runnable runnable) {
        this.runOutOfContext(runnable);
    }

    public <T> T outOfCustomerContext(Callable<T> callable) {
        return this.runOutOfContext(() -> {
            try {
                return callable.call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void outOfCustomerContext(Runnable runnable) {
        this.runOutOfContext(runnable);
    }

    public boolean isInCustomerContext() {
        return this.isCurrentlyInContext();
    }

    @Override
    protected void onEnteringInvocation(boolean previousState, boolean currentState) {
    }

    @Override
    protected void onExitingInvocation(boolean previousState, boolean currentState) {
        try {
            this.permissionManager.flushCache();
        }
        catch (RuntimeException e) {
            log.warn((Object)"Unable to flush permissions cache", (Throwable)e);
        }
    }
}

