/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.utils;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginInformation;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.servicedesk.bootstrap.version.BuildProperties;
import com.atlassian.servicedesk.internal.api.util.ServiceDeskApplicationVersionUtil;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class SdApplicationVersionUtilImpl
implements ServiceDeskApplicationVersionUtil {
    private final BuildProperties buildProperties;
    private final PluginAccessor pluginAccessor;

    @Autowired
    public SdApplicationVersionUtilImpl(BuildProperties buildProperties, PluginAccessor pluginAccessor) {
        this.buildProperties = buildProperties;
        this.pluginAccessor = pluginAccessor;
    }

    public String getServiceDeskApplicationVersion() {
        String version = this.getVersionToDisplay();
        return this.cleanupDevVersion(version);
    }

    private String cleanupDevVersion(String version) {
        if (StringUtils.contains((String)version, (String)"SNAPSHOT")) {
            return String.format("%s#%s", version, this.buildProperties.getChangeSet());
        }
        return version;
    }

    private String getVersionToDisplay() {
        Optional<String> applicationVersion = this.getApplicationVersion();
        if (applicationVersion.isPresent()) {
            return applicationVersion.get();
        }
        return this.buildProperties.getVersion();
    }

    private Optional<String> getApplicationVersion() {
        Plugin serviceDeskApplicationPlugin = this.pluginAccessor.getPlugin("com.atlassian.servicedesk.application");
        if (serviceDeskApplicationPlugin == null) {
            return Optional.empty();
        }
        PluginInformation pluginInformation = serviceDeskApplicationPlugin.getPluginInformation();
        String version = pluginInformation.getVersion();
        return Optional.ofNullable(version);
    }
}

