/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.util.tokens.jwt;

import com.atlassian.pocketknife.api.persistence.GlobalPropertyDao;
import io.atlassian.fugue.Option;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class JwtSecretStore {
    private static final String KEY = "servicedesk.jwt.secret";
    private final GlobalPropertyDao globalPropertyDao;

    @Autowired
    JwtSecretStore(GlobalPropertyDao globalPropertyDao) {
        this.globalPropertyDao = globalPropertyDao;
    }

    Option<String> getSecret() {
        String value = this.globalPropertyDao.getTextProperty(KEY);
        if (StringUtils.isEmpty((String)value)) {
            return Option.none();
        }
        return Option.some((Object)value);
    }

    void saveSecret(String secret) {
        this.globalPropertyDao.setTextProperty(KEY, secret);
    }
}

