/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.util.tokens.jwt;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.jwt.SigningAlgorithm;
import com.atlassian.jwt.internal.security.SecretGenerator;
import com.atlassian.servicedesk.internal.util.tokens.jwt.JwtSecretKeyService;
import com.atlassian.servicedesk.internal.util.tokens.jwt.JwtSecretStore;
import io.atlassian.fugue.Option;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JwtSecretKeyServiceImpl
implements JwtSecretKeyService {
    private static final String SHARED_SECRET_KEY_LOCK = JwtSecretKeyServiceImpl.class.getCanonicalName();
    private static final long LOCK_TIMEOUT_SECONDS = 60L;
    private final Logger logger = LoggerFactory.getLogger(JwtSecretKeyServiceImpl.class);
    private final ClusterLockService clusterLockService;
    private final JwtSecretStore jwtSecretStore;

    @Autowired
    public JwtSecretKeyServiceImpl(ClusterLockService clusterLockService, JwtSecretStore jwtSecretStore) {
        this.clusterLockService = clusterLockService;
        this.jwtSecretStore = jwtSecretStore;
    }

    @Override
    public String getSecretKey() {
        return (String)this.jwtSecretStore.getSecret().fold(() -> this.generateAndStoreSecret(), value -> value);
    }

    private String generateAndStoreSecret() {
        ClusterLock updateLock = this.clusterLockService.getLockForName(SHARED_SECRET_KEY_LOCK);
        boolean locked = false;
        try {
            locked = updateLock.tryLock(60L, TimeUnit.SECONDS);
            if (locked) {
                Option<String> sotredSecretOpt = this.jwtSecretStore.getSecret();
                if (sotredSecretOpt.isDefined()) {
                    String string = (String)sotredSecretOpt.get();
                    return string;
                }
                String generatedSecret = this.generateSecret();
                this.jwtSecretStore.saveSecret(generatedSecret);
                String string = generatedSecret;
                return string;
            }
            try {
                throw new IllegalStateException("Failed to acquire update lock for generating jwt secret");
            }
            catch (InterruptedException e) {
                this.logger.warn(String.format("interrupted while trying to obtain lock with key %s within %d seconds", SHARED_SECRET_KEY_LOCK, 60L));
                throw new IllegalStateException("Failed to acquire update lock for generating jwt secret");
            }
        }
        finally {
            if (locked) {
                updateLock.unlock();
            }
        }
    }

    private String generateSecret() {
        return SecretGenerator.generateUrlSafeSharedSecret((SigningAlgorithm)SigningAlgorithm.HS256);
    }
}

