/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.util;

import com.atlassian.pocketknife.api.logging.Log;
import java.io.IOException;
import org.codehaus.jackson.map.ObjectMapper;

public class JsonSerializer<T> {
    protected final Log log = Log.with(this.getClass());
    private final ObjectMapper serializer = new ObjectMapper();
    private final Class<T> typeClass;

    public JsonSerializer(Class<T> typeClass) {
        this.typeClass = typeClass;
    }

    public String serialize(T slaValue) {
        return this.serializeObject(slaValue);
    }

    private String serializeObject(T value) {
        try {
            return this.serializer.writeValueAsString(value);
        }
        catch (IOException e) {
            this.log.error(e.getMessage(), new Object[0]);
            return null;
        }
    }

    public T deserialize(String text) {
        return this.deserializeValue(text);
    }

    private T deserializeValue(String text) {
        try {
            return (T)this.serializer.readValue(text, this.typeClass);
        }
        catch (IOException e) {
            this.log.error(e.getMessage(), new Object[0]);
            return null;
        }
    }
}

