/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.util;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.util.ImportUtils;
import com.atlassian.pocketknife.api.logging.Log;

public final class IssueIndexingHelper {
    private static final Log log = Log.with(IssueIndexingHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reindexIssue(Issue issue, IssueIndexManager issueIndexManager) {
        IndexingContext indexingContext = IssueIndexingHelper.activateIndexing(issueIndexManager);
        try {
            issueIndexManager.reIndex(issue);
        }
        catch (IndexException e) {
            log.error("Error reindexing issue prior to SLA computation. This should not prevent SLA working", new Object[]{e});
        }
        finally {
            IssueIndexingHelper.resetIndexingToPrevious(indexingContext, issueIndexManager);
        }
    }

    public static IndexingContext activateIndexing(IssueIndexManager issueIndexManager) {
        IndexingContext context = new IndexingContext();
        context.isIndexIssues = ImportUtils.isIndexIssues();
        context.isHeld = issueIndexManager.isHeld();
        if (!context.isIndexIssues) {
            ImportUtils.setIndexIssues((boolean)true);
        }
        if (context.isHeld) {
            try {
                issueIndexManager.release();
            }
            catch (IndexException e) {
                log.error("Error reactivating indexing %s", new Object[]{e.getMessage()});
            }
        }
        return context;
    }

    public static void resetIndexingToPrevious(IndexingContext aIndexingContext, IssueIndexManager issueIndexManager) {
        if (aIndexingContext == null) {
            return;
        }
        if (aIndexingContext.isHeld) {
            issueIndexManager.hold();
        }
        ImportUtils.setIndexIssues((boolean)aIndexingContext.isIndexIssues);
    }

    public static class IndexingContext {
        public boolean isIndexIssues;
        public boolean isHeld;
    }
}

